/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;
import mainClasses.GALibrary;
import mainClasses.GAProgram;

public class ProgCommand
extends AICommand {
    private int ID = 0;
    private GALibrary library = null;

    @Override
    public String getShortName() {
        return String.format("PROG%6d", this.ID).trim();
    }

    @Override
    public String getLongName() {
        return String.format("PROG%6d", this.ID).trim();
    }

    @Override
    public int getParameterCount() {
        return 0;
    }

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        GAProgram program = this.library.getProgram(this.ID);
        int ret = program.getProgram().doCommand(withSideEffects);
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.length() > 4) {
            String code = string.substring(0, 4);
            String id = string.substring(4);
            if (code.equalsIgnoreCase("PROG")) {
                try {
                    int progID = Integer.valueOf(id);
                    ProgCommand ret = new ProgCommand(this);
                    ret.setProgID(progID);
                    return ret;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public ProgCommand() {
        this.library = null;
        this.ID = -1;
    }

    public ProgCommand(ProgCommand src) {
        super(src);
        this.library = src.library;
        this.ID = src.ID;
    }

    public int setProgID(int progID) {
        this.ID = progID;
        return this.ID;
    }

    public int getProgID() {
        return this.ID;
    }

    public GALibrary setLibrary(GALibrary library) {
        this.library = library;
        return this.library;
    }

    public GALibrary getLibrary() {
        return this.library;
    }

    @Override
    public IAICommand copy() {
        return new ProgCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        ProgCommand ret = new ProgCommand();
        ret.setLogger(this.getLogger());
        return ret;
    }

    @Override
    public boolean isConstant() {
        GAProgram program = this.library.getProgram(this.ID);
        if (program == null) {
            return false;
        }
        return ((AICommand)program.getProgram()).isConstant();
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.NEVER;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        GAProgram program = this.library.getProgram(this.ID);
        if (program == null) {
            return false;
        }
        return ((AICommand)program.getProgram()).hasSideEffects(inclusiveParameter);
    }
}

