/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;
import simulation.Memory;

public class ReadCommand
extends AICommand
implements IAICommand {
    private Memory memory = null;

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            int pos = this.getParameter(0).doCommand(withSideEffects) / 1000;
            if (!this.stop) {
                if (this.memory != null) {
                    ret = this.memory.getValue(pos);
                } else {
                    this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Memory not found");
                }
            }
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public String getLongName() {
        return "ReadMemory";
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public String getShortName() {
        return "READ";
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals(this.getShortName())) {
            return new ReadCommand(this);
        }
        return null;
    }

    public void setMemory(Memory mem) {
        this.memory = mem;
    }

    public ReadCommand() {
    }

    public ReadCommand(ReadCommand src) {
        super(src);
    }

    @Override
    public IAICommand copy() {
        return new ReadCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.ALWAYS;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        return true;
    }
}

