/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;

public class SleepCommand
extends AICommand
implements IAICommand {
    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            int value = Math.abs(this.getParameter(0).doCommand(withSideEffects) / 1000);
            if (withSideEffects && !this.stop) {
                int i = value / 100;
                while (i > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.stop) break;
                    ++i;
                }
                if (!this.stop) {
                    try {
                        Thread.sleep(value % 100);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else {
            this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Missing first parameter");
        }
        if (this.stop) {
            return 0;
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ",");
        if (this.getParameter(1) != null) {
            ret += this.getParameter(1).doCommand(withSideEffects);
        } else {
            this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Missing second parameter");
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public String getLongName() {
        return "Sleep";
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public String getShortName() {
        return "SLEEP";
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals(this.getShortName())) {
            return new SleepCommand(this);
        }
        return null;
    }

    public SleepCommand() {
    }

    public SleepCommand(SleepCommand src) {
        super(src);
    }

    @Override
    public IAICommand copy() {
        return new SleepCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        boolean ret = true;
        if (this.getParameter(1) != null) {
            ret = ((AICommand)this.getParameter(1)).isConstant();
        }
        return ret;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.ALWAYS;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        return true;
    }
}

