/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;

public class SumCommand
extends AICommand
implements IAICommand {
    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            int count = this.getParameter(0).doCommand(withSideEffects) / 1000;
            if (count > 1000) {
                count = 1000;
            }
            if (this.getParameter(1) != null) {
                int i = 0;
                while (i < count) {
                    if (!this.stop) {
                        ret += this.getParameter(1).doCommand(withSideEffects);
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Missing second parameter");
            }
        } else {
            this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Missing first parameter");
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public String getLongName() {
        return "Sum";
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public String getShortName() {
        return "SUM";
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals(this.getShortName())) {
            return new SumCommand(this);
        }
        return null;
    }

    public SumCommand() {
    }

    public SumCommand(SumCommand src) {
        super(src);
    }

    @Override
    public IAICommand copy() {
        return new SumCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        boolean ret = true;
        int i = 0;
        while (i < this.getCurrentParameterCount()) {
            ret = ret && ((AICommand)this.getParameter(i)).isConstant();
            ++i;
        }
        return ret;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        if (paramID == 0) {
            return AICommand.IsExecutedType.ALWAYS;
        }
        if (this.getParameterCount() > 0 && ((AICommand)this.getParameter(0)).isConstant()) {
            int value = this.getParameter(0).doCommand(true) / 1000;
            if (value < 1) {
                return AICommand.IsExecutedType.NEVER;
            }
            return AICommand.IsExecutedType.ALWAYS;
        }
        return AICommand.IsExecutedType.MAYBE;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        boolean ret = false;
        if (inclusiveParameter) {
            int i = 0;
            while (i < this.getCurrentParameterCount()) {
                ret = ret || ((AICommand)this.getParameter(i)).hasSideEffects(inclusiveParameter);
                ++i;
            }
        }
        return ret;
    }
}

