/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;

public class TanCommand
extends AICommand {
    @Override
    public String getShortName() {
        return "TAN";
    }

    @Override
    public String getLongName() {
        return "Tangens";
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            ret = this.getParameter(0).doCommand(withSideEffects);
        } else {
            this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Missing first parameter");
        }
        double a = (double)ret / 1000.0;
        ret = (int)(Math.tan(a) * 1000.0);
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    public TanCommand() {
    }

    public TanCommand(TanCommand src) {
        super(src);
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals(this.getShortName())) {
            return new TanCommand(this);
        }
        return null;
    }

    @Override
    public IAICommand copy() {
        return new TanCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        boolean ret = true;
        int i = 0;
        while (i < this.getCurrentParameterCount()) {
            ret = ret && ((AICommand)this.getParameter(i)).isConstant();
            ++i;
        }
        return ret;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.ALWAYS;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        boolean ret = false;
        if (inclusiveParameter) {
            int i = 0;
            while (i < this.getCurrentParameterCount()) {
                ret = ret || ((AICommand)this.getParameter(i)).hasSideEffects(inclusiveParameter);
                ++i;
            }
        }
        return ret;
    }
}

