/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;
import simulation.Memory;

public class WriteCommand
extends AICommand
implements IAICommand {
    private Memory memory = null;

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            int pos = this.getParameter(0).doCommand(withSideEffects) / 1000;
            this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ",");
            if (this.getParameter(1) != null) {
                ret = this.getParameter(1).doCommand(withSideEffects);
                if (withSideEffects && !this.stop) {
                    if (this.memory != null) {
                        ret = this.memory.setValue(pos, ret);
                    } else {
                        this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Memory not found");
                    }
                }
            } else {
                this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Missing second parameter");
            }
        } else {
            this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Missing first parameter");
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public String getLongName() {
        return "WriteMemory";
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public String getShortName() {
        return "WRITE";
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals(this.getShortName())) {
            return new WriteCommand(this);
        }
        return null;
    }

    public void setMemory(Memory mem) {
        this.memory = mem;
    }

    public WriteCommand() {
    }

    public WriteCommand(WriteCommand src) {
        super(src);
    }

    @Override
    public IAICommand copy() {
        return new WriteCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        boolean ret = true;
        if (this.getCurrentParameterCount() > 1) {
            ret = ((AICommand)this.getParameter(1)).isConstant();
        }
        return ret;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.ALWAYS;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        return true;
    }
}

