/*
 * Decompiled with CFR 0.152.
 */
package extern;

import extern.Asteroid;
import extern.FramePacket;
import extern.Saucer;
import extern.Ship;
import extern.Shot;
import java.util.ArrayList;
import java.util.List;

public class GameStatus
implements Cloneable {
    protected int ticks;
    protected Ship ship = null;
    protected Saucer saucer = null;
    protected List<Asteroid> asteroids = new ArrayList<Asteroid>();
    protected List<Shot> shots = new ArrayList<Shot>();
    protected String displayText = "";
    protected int lastPoints = -1;

    private void clear() {
        this.ticks = 0;
        this.ship = null;
        this.saucer = null;
        this.asteroids.clear();
        this.shots.clear();
    }

    public void interpretScreen(FramePacket framePacket, int ticks) {
        int dx = 0;
        int dy = 0;
        int vx = 0;
        int vy = 0;
        int vz = 0;
        int vs = 0;
        int v1x = 0;
        int v1y = 0;
        int shipdetect = 0;
        this.clear();
        this.ticks = ticks;
        int initialJump = framePacket.readVectorRAMWord(0);
        if (initialJump != 57345 && initialJump != 57857) {
            return;
        }
        String displayText = "";
        int pc = 1;
        while (true) {
            int currentWord = framePacket.readVectorRAMWord(pc);
            int op = currentWord >> 12;
            switch (op) {
                case 10: {
                    int nextWord = framePacket.readVectorRAMWord(pc + 1);
                    vy = currentWord & 0x3FF;
                    vx = nextWord & 0x3FF;
                    vs = nextWord >> 12;
                    break;
                }
                case 11: {
                    this.displayText = displayText;
                    this.setLastPoints();
                    return;
                }
                case 12: {
                    Asteroid.Size saucerSize = Asteroid.Size.BIG;
                    if (vs == 15) {
                        saucerSize = Asteroid.Size.MIDDLE;
                    } else if (vs == 14) {
                        saucerSize = Asteroid.Size.SMALL;
                    }
                    switch (currentWord & 0xFFF) {
                        case 2291: {
                            this.asteroids.add(new Asteroid(vx, vy, Asteroid.Type.TYPE_1, saucerSize));
                            break;
                        }
                        case 2303: {
                            this.asteroids.add(new Asteroid(vx, vy, Asteroid.Type.TYPE_2, saucerSize));
                            break;
                        }
                        case 2317: {
                            this.asteroids.add(new Asteroid(vx, vy, Asteroid.Type.TYPE_3, saucerSize));
                            break;
                        }
                        case 2330: {
                            this.asteroids.add(new Asteroid(vx, vy, Asteroid.Type.TYPE_4, saucerSize));
                            break;
                        }
                        case 2345: {
                            this.saucer = new Saucer(vx, vy, vs == 15 ? Saucer.Size.BIG : Saucer.Size.SMALL);
                            break;
                        }
                        case 2680: {
                            displayText = String.valueOf(displayText) + "A";
                            break;
                        }
                        case 2688: {
                            displayText = String.valueOf(displayText) + "B";
                            break;
                        }
                        case 2701: {
                            displayText = String.valueOf(displayText) + "C";
                            break;
                        }
                        case 2707: {
                            displayText = String.valueOf(displayText) + "D";
                            break;
                        }
                        case 2715: {
                            displayText = String.valueOf(displayText) + "E";
                            break;
                        }
                        case 2723: {
                            displayText = String.valueOf(displayText) + "F";
                            break;
                        }
                        case 2730: {
                            displayText = String.valueOf(displayText) + "G";
                            break;
                        }
                        case 2739: {
                            displayText = String.valueOf(displayText) + "H";
                            break;
                        }
                        case 2746: {
                            displayText = String.valueOf(displayText) + "I";
                            break;
                        }
                        case 2753: {
                            displayText = String.valueOf(displayText) + "J";
                            break;
                        }
                        case 2759: {
                            displayText = String.valueOf(displayText) + "K";
                            break;
                        }
                        case 2765: {
                            displayText = String.valueOf(displayText) + "L";
                            break;
                        }
                        case 2770: {
                            displayText = String.valueOf(displayText) + "M";
                            break;
                        }
                        case 2776: {
                            displayText = String.valueOf(displayText) + "N";
                            break;
                        }
                        case 2781: {
                            displayText = String.valueOf(displayText) + "O";
                            break;
                        }
                        case 2787: {
                            displayText = String.valueOf(displayText) + "P";
                            break;
                        }
                        case 2794: {
                            displayText = String.valueOf(displayText) + "Q";
                            break;
                        }
                        case 2803: {
                            displayText = String.valueOf(displayText) + "R";
                            break;
                        }
                        case 2811: {
                            displayText = String.valueOf(displayText) + "S";
                            break;
                        }
                        case 2818: {
                            displayText = String.valueOf(displayText) + "T";
                            break;
                        }
                        case 2824: {
                            displayText = String.valueOf(displayText) + "U";
                            break;
                        }
                        case 2830: {
                            displayText = String.valueOf(displayText) + "V";
                            break;
                        }
                        case 2835: {
                            displayText = String.valueOf(displayText) + "W";
                            break;
                        }
                        case 2842: {
                            displayText = String.valueOf(displayText) + "X";
                            break;
                        }
                        case 2847: {
                            displayText = String.valueOf(displayText) + "Y";
                            break;
                        }
                        case 2854: {
                            displayText = String.valueOf(displayText) + "Z";
                            break;
                        }
                        case 2860: {
                            displayText = String.valueOf(displayText) + " ";
                            break;
                        }
                        case 2862: {
                            displayText = String.valueOf(displayText) + "1";
                            break;
                        }
                        case 2866: {
                            displayText = String.valueOf(displayText) + "2";
                            break;
                        }
                        case 2874: {
                            displayText = String.valueOf(displayText) + "3";
                            break;
                        }
                        case 2881: {
                            displayText = String.valueOf(displayText) + "4";
                            break;
                        }
                        case 2888: {
                            displayText = String.valueOf(displayText) + "5";
                            break;
                        }
                        case 2895: {
                            displayText = String.valueOf(displayText) + "6";
                            break;
                        }
                        case 2902: {
                            displayText = String.valueOf(displayText) + "7";
                            break;
                        }
                        case 2907: {
                            displayText = String.valueOf(displayText) + "8";
                            break;
                        }
                        case 2915: {
                            displayText = String.valueOf(displayText) + "9";
                        }
                    }
                    break;
                }
                case 13: {
                    this.displayText = displayText;
                    this.setLastPoints();
                    return;
                }
                case 14: {
                    this.displayText = displayText;
                    this.setLastPoints();
                    return;
                }
                case 15: {
                    break;
                }
                default: {
                    int nextWord = framePacket.readVectorRAMWord(pc + 1);
                    dy = currentWord & 0x3FF;
                    if ((currentWord & 0x400) != 0) {
                        dy = -dy;
                    }
                    dx = nextWord & 0x3FF;
                    if ((nextWord & 0x400) != 0) {
                        dx = -dx;
                    }
                    vz = nextWord >> 12;
                    if (dx == 0 && dy == 0 && vz == 15) {
                        this.shots.add(new Shot(vx, vy));
                    }
                    if (op == 6 && vz == 12 && dx != 0 && dy != 0) {
                        switch (shipdetect) {
                            case 0: {
                                v1x = dx;
                                v1y = dy;
                                ++shipdetect;
                                break;
                            }
                            case 1: {
                                this.ship = new Ship(vx, vy, v1x - dx, v1y - dy);
                                ++shipdetect;
                            }
                        }
                        break;
                    }
                    if (shipdetect != true) break;
                    shipdetect = 0;
                }
            }
            if (op <= 10) {
                ++pc;
            }
            if (op == 14) continue;
            ++pc;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ship != null) {
            stringBuilder.append("ship:").append(this.ship.getX()).append(",").append(this.ship.getY()).append(";").append(this.ship.getOrientation().getX()).append(",").append(this.ship.getOrientation().getY()).append("\n");
        }
        if (this.saucer != null) {
            stringBuilder.append("saucer:").append(this.saucer.getX()).append(",").append(this.saucer.getY()).append(";").append((Object)this.saucer.getSize()).append("\n");
        }
        for (Asteroid asteroid : this.asteroids) {
            stringBuilder.append("asteroid:").append(asteroid.getX()).append(",").append(asteroid.getY()).append(";").append((Object)asteroid.getType()).append(";").append((Object)asteroid.getSize()).append("\n");
        }
        for (Shot shot : this.shots) {
            stringBuilder.append("shot:").append(shot.getX()).append(",").append(shot.getY()).append("\n");
        }
        return stringBuilder.toString();
    }

    public int getTicks() {
        return this.ticks;
    }

    public Ship getShip() {
        return this.ship;
    }

    public Saucer getSaucer() {
        return this.saucer;
    }

    public List<Asteroid> getAsteroids() {
        return this.asteroids;
    }

    public List<Shot> getShots() {
        return this.shots;
    }

    public String getText() {
        return this.displayText;
    }

    public int getCurrentPoints() {
        String tmp = this.displayText;
        tmp = tmp.replace("O", "0");
        String[] fields = tmp.split(" ");
        int ret = -1;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].length() > 0) {
                try {
                    ret = Integer.valueOf(fields[i]);
                }
                catch (NumberFormatException e) {
                    ret = -1;
                }
                break;
            }
            ++i;
        }
        return ret;
    }

    public void setLastPoints() {
        int tmp = this.getCurrentPoints();
        if (tmp >= 0) {
            this.lastPoints = tmp;
        }
    }

    public int getLastPoints() {
        return this.lastPoints;
    }
}

