/*
 * Decompiled with CFR 0.152.
 */
package extern;

import java.net.DatagramPacket;

public class KeysPacket {
    private static final byte KEY_HYPERSPACE = 1;
    private static final byte KEY_FIRE = 2;
    private static final byte KEY_THRUST = 4;
    private static final byte KEY_RIGHT = 8;
    private static final byte KEY_LEFT = 16;
    private static final byte KEY_START = 32;
    private byte[] payload = new byte[8];
    private DatagramPacket datagramPacket = new DatagramPacket(this.payload, this.payload.length);

    public KeysPacket() {
        this.payload[0] = 99;
        this.payload[1] = 116;
        this.payload[2] = 109;
        this.payload[3] = 97;
        this.payload[4] = 109;
        this.payload[5] = 101;
        this.payload[6] = 64;
        this.payload[7] = 0;
    }

    public void clear() {
        this.payload[6] = 64;
    }

    public void hyperspace(boolean pressed) {
        this.payload[6] = pressed ? (byte)(this.payload[6] | 1) : (byte)(this.payload[6] & 0xFFFFFFFE);
    }

    public void fire(boolean pressed) {
        this.payload[6] = pressed ? (byte)(this.payload[6] | 2) : (byte)(this.payload[6] & 0xFFFFFFFD);
    }

    public void thrust(boolean pressed) {
        this.payload[6] = pressed ? (byte)(this.payload[6] | 4) : (byte)(this.payload[6] & 0xFFFFFFFB);
    }

    public void left(boolean pressed) {
        if (pressed) {
            this.payload[6] = (byte)(this.payload[6] | 0x10);
            this.right(false);
        } else {
            this.payload[6] = (byte)(this.payload[6] & 0xFFFFFFEF);
        }
    }

    public void right(boolean pressed) {
        if (pressed) {
            this.payload[6] = (byte)(this.payload[6] | 8);
            this.left(false);
        } else {
            this.payload[6] = (byte)(this.payload[6] & 0xFFFFFFF7);
        }
    }

    public void start(boolean pressed) {
        this.payload[6] = pressed ? (byte)(this.payload[6] | 0x20) : (byte)(this.payload[6] & 0xFFFFFFDF);
    }

    public void reset() {
        this.payload[6] = 64;
    }

    public byte getPing() {
        return this.payload[7];
    }

    public void setPing(byte ping) {
        this.payload[7] = ping;
    }

    public DatagramPacket getDatagramPacket() {
        return this.datagramPacket;
    }
}

