/*
 * Decompiled with CFR 0.152.
 */
package extern;

import extern.FramePacket;
import extern.KeysPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ServerConnection {
    public final int SERVER_PORT = 1979;
    protected DatagramSocket socket;
    private boolean stopped = false;
    private String servername = "";

    public ServerConnection(String serverName) {
        this.open(serverName);
    }

    public void open(String serverName) {
        this.servername = serverName;
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        try {
            this.socket.connect(InetAddress.getByName(this.servername), 1979);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void close() {
        this.socket.close();
    }

    public void receive(FramePacket framePacket) throws IOException {
        if (!this.socket.isConnected()) {
            try {
                this.socket.connect(InetAddress.getByName(this.servername), 1979);
            }
            catch (UnknownHostException e) {
                System.out.println("ServerConnection.receive(): ERROR: can't connect with game");
                return;
            }
        }
        DatagramPacket datagramPacket = framePacket.getDatagramPacket();
        this.stopped = false;
        while (!this.stopped) {
            this.socket.receive(datagramPacket);
            if (datagramPacket.getLength() == 1026) break;
            System.out.println("ServerConnection.receive(): ERROR: received packet with wrong size");
        }
    }

    public void send(KeysPacket keysPacket) throws IOException {
        if (!this.socket.isConnected()) {
            try {
                this.socket.connect(InetAddress.getByName(this.servername), 1979);
            }
            catch (UnknownHostException e) {
                System.out.println("ServerConnection.receive(): ERROR: can't connect with game");
                return;
            }
        }
        this.socket.send(keysPacket.getDatagramPacket());
    }

    public void stop() {
        this.stopped = true;
        this.socket.close();
    }

    public void setServername(String servername) {
        this.close();
        this.open(servername);
    }
}

