/*
 * Decompiled with CFR 0.152.
 */
package global;

import commands.AICommand;
import commands.IAICommand;
import global.Logger;
import java.util.ArrayList;
import java.util.List;

public class CreateProgramTree {
    private List<IAICommand> commandList = new ArrayList<IAICommand>();
    private Logger logger = null;

    public void setLogger(Logger newLogger) {
        this.logger = newLogger;
    }

    public void addCommand(IAICommand command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public void addCommands(List<IAICommand> list) {
        int i = 0;
        while (i < list.size()) {
            this.commandList.add(list.get(i));
            ++i;
        }
    }

    public void clearCommandList() {
        this.commandList.clear();
    }

    public IAICommand findCommand(String code) {
        IAICommand ret = null;
        if (this.commandList == null) {
            if (this.logger != null) {
                this.logger.LogError("CreateProgramTree.findCommand", "no command list");
            }
            return null;
        }
        int i = 0;
        while (i < this.commandList.size()) {
            if (this.commandList.get(i) != null && (ret = this.commandList.get(i).isThisCommand(code)) != null) break;
            ++i;
        }
        if (ret == null && this.logger != null) {
            this.logger.LogError("CreateProgramTree.findCommand", "command not found: " + code);
        }
        return ret;
    }

    public int createTree(String[] codes, int pos, AICommand root) {
        if (root == null) {
            return pos;
        }
        int i = 0;
        while (i < root.getParameterCount()) {
            if (pos < codes.length) {
                IAICommand param = null;
                param = this.findCommand(codes[pos]);
                if (param != null) {
                    root.addParameter(param);
                    pos = this.createTree(codes, pos + 1, (AICommand)param);
                }
            }
            ++i;
        }
        return pos;
    }

    public IAICommand interpret(String code) {
        String[] codes = code.split(" ");
        IAICommand ret = null;
        if (codes.length > 0 && (ret = this.findCommand(codes[0])) != null) {
            this.createTree(codes, 1, (AICommand)ret);
        }
        return ret;
    }
}

