/*
 * Decompiled with CFR 0.152.
 */
package globalTests;

import commands.AICommand;
import commands.AddCommand;
import commands.KeyCommand;
import commands.NumberCommand;
import commands.SleepCommand;
import global.CreateProgramTree;
import global.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CreateProgramTreeTest
extends TestCase {
    private CreateProgramTree cpt = null;
    private AddCommand addCommand = null;
    private NumberCommand numberCommand = null;
    private Logger logger = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.logger = new Logger();
        this.cpt = new CreateProgramTree();
        this.cpt.setLogger(this.logger);
        this.addCommand = new AddCommand();
        this.addCommand.setLogger(this.logger);
        this.numberCommand = new NumberCommand();
        this.numberCommand.setLogger(this.logger);
        this.cpt.addCommand(this.addCommand);
        this.cpt.addCommand(this.numberCommand);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFindCommandOK() {
        AICommand cmd = (AICommand)this.cpt.findCommand("ADD");
        if (cmd != null) {
            CreateProgramTreeTest.assertEquals("ADD", cmd.getShortName());
        } else {
            CreateProgramTreeTest.fail("Command not found");
        }
    }

    public void testNotFindCommand() {
        try {
            AICommand cmd = (AICommand)this.cpt.findCommand("FALSCH");
            if (cmd != null) {
                CreateProgramTreeTest.fail("Not existing command found");
            }
        }
        catch (Exception e) {
            CreateProgramTreeTest.fail("Exception: " + e.getMessage());
        }
    }

    public void testCreateTreeOK() {
        String[] codes = new String[]{"ADD", "ADD", "123456", "654321", "111111"};
        AddCommand root = new AddCommand();
        this.cpt.createTree(codes, 1, root);
        CreateProgramTreeTest.assertEquals(2, root.getCurrentParameterCount());
        CreateProgramTreeTest.assertEquals("ADD", ((AICommand)root.getParameter(0)).getShortName());
        CreateProgramTreeTest.assertEquals("111111", ((AICommand)root.getParameter(1)).getShortName());
        AICommand subItem = (AICommand)root.getParameter(0);
        CreateProgramTreeTest.assertEquals(2, subItem.getCurrentParameterCount());
        CreateProgramTreeTest.assertEquals("123456", ((AICommand)subItem.getParameter(0)).getShortName());
        CreateProgramTreeTest.assertEquals("654321", ((AICommand)subItem.getParameter(1)).getShortName());
    }

    public void testCreateTreeMissingParameters() {
        String[] codes2 = new String[]{"ADD", "ADD"};
        AddCommand root2 = new AddCommand();
        try {
            this.cpt.createTree(codes2, 1, root2);
        }
        catch (Exception e) {
            CreateProgramTreeTest.fail("No exception expected even if there are too less parameters: " + e.getMessage());
        }
    }

    public void testCreateTreeFalseCommand() {
        String[] codes2 = new String[]{"ADD", "NONESENSEE"};
        AddCommand root2 = new AddCommand();
        try {
            this.cpt.createTree(codes2, 1, root2);
        }
        catch (Exception e) {
            CreateProgramTreeTest.fail("No exception expected even by wrong command name: " + e.getMessage());
        }
    }

    public void testInterpretOK() {
        AICommand root = (AICommand)this.cpt.interpret("ADD ADD 123456 654321 111111");
        CreateProgramTreeTest.assertEquals("ADD", root.getShortName());
        CreateProgramTreeTest.assertEquals("ADD", ((AICommand)root.getParameter(0)).getShortName());
        CreateProgramTreeTest.assertEquals("111111", ((AICommand)root.getParameter(1)).getShortName());
        AICommand subItem = (AICommand)root.getParameter(0);
        CreateProgramTreeTest.assertEquals("123456", ((AICommand)subItem.getParameter(0)).getShortName());
        CreateProgramTreeTest.assertEquals("654321", ((AICommand)subItem.getParameter(1)).getShortName());
    }

    public void testInterpret2() {
        KeyCommand keyCommand = new KeyCommand();
        keyCommand.setLogger(this.logger);
        this.cpt.addCommand(keyCommand);
        SleepCommand sleepCommand = new SleepCommand();
        sleepCommand.setLogger(this.logger);
        this.cpt.addCommand(sleepCommand);
        AICommand root = null;
        try {
            root = (AICommand)this.cpt.interpret("ADD KEYP 1000 SLEEP 1000 KEYR 1000");
        }
        catch (Exception e) {
            CreateProgramTreeTest.fail("No exception expected during interpretation: " + e.getMessage());
        }
        try {
            CreateProgramTreeTest.assertEquals("ADD", root.getShortName());
        }
        catch (Exception e) {
            CreateProgramTreeTest.fail("No exception expected by getting name of root element: " + e.getMessage());
        }
        try {
            CreateProgramTreeTest.assertEquals(2, root.getCurrentParameterCount());
            CreateProgramTreeTest.assertEquals("KEYP", ((AICommand)root.getParameter(0)).getShortName());
            CreateProgramTreeTest.assertEquals("SLEEP", ((AICommand)root.getParameter(1)).getShortName());
            AICommand si = (AICommand)root.getParameter(0);
            CreateProgramTreeTest.assertEquals(1, si.getCurrentParameterCount());
            CreateProgramTreeTest.assertEquals("1000", ((AICommand)si.getParameter(0)).getShortName());
            si = (AICommand)root.getParameter(1);
            CreateProgramTreeTest.assertEquals(2, si.getCurrentParameterCount());
            CreateProgramTreeTest.assertEquals("1000", ((AICommand)si.getParameter(0)).getShortName());
            CreateProgramTreeTest.assertEquals("KEYR", ((AICommand)si.getParameter(1)).getShortName());
            si = (AICommand)si.getParameter(1);
            CreateProgramTreeTest.assertEquals(1, si.getCurrentParameterCount());
            CreateProgramTreeTest.assertEquals("1000", ((AICommand)si.getParameter(0)).getShortName());
            CreateProgramTreeTest.assertEquals("<log>\n</log>\n", this.logger.getLog());
            root.doCommand();
        }
        catch (Exception e) {
            CreateProgramTreeTest.fail("No exception expected during tree checking: " + e.getMessage());
        }
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("CreateProgramTree");
        suite.addTestSuite(CreateProgramTreeTest.class);
        return suite;
    }
}

