/*
 * Decompiled with CFR 0.152.
 */
package gui;

import global.CreateProgramTree;
import gui.ExitAdapter;
import gui.JustStartBestAdapter;
import gui.LoadAdapter;
import gui.MergeAdapter;
import gui.NewAdapter;
import gui.NewServerAdapter;
import gui.PopulationGenerateAdapter;
import gui.SaveAdapter;
import gui.ServerConsoleAdapter;
import gui.ServerListAdapter;
import gui.ShowPopulationAdapter;
import gui.StatisticAdapter;
import mainClasses.ExecutionManager;
import mainClasses.GAGenerationGenerator;
import mainClasses.GAPopulation;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MainWindow {
    private ExitAdapter exitAdapter = null;
    private SaveAdapter saveAdapter = null;
    private LoadAdapter loadAdapter = null;
    private MergeAdapter mergeAdapter = null;
    private NewAdapter newAdapter = null;
    private ShowPopulationAdapter showPopulationAdapter = null;
    private PopulationGenerateAdapter populationGenerateAdapter = null;
    private NewServerAdapter newServerAdapter = null;
    private ServerConsoleAdapter serverConsoleAdapter = null;
    private ServerListAdapter serverListAdapter = null;
    private JustStartBestAdapter justStartBestAdapter = null;
    private StatisticAdapter statisticAdapter = null;
    private GAPopulation population = null;
    private GAGenerationGenerator generationGenerator = null;
    private CreateProgramTree createProgramTree = null;
    private ExecutionManager executionManager = null;
    private Display display = new Display();
    private Shell shell = new Shell(this.display);

    public MainWindow() {
        this.shell.setText("Asteroids Player");
        this.CreateListener(this.shell);
        this.CreateMenuBar(this.shell);
        this.shell.setLayout(new FillLayout());
        Text text = new Text(this.shell, 2826);
        text.setText("Program: (c) by Sebastian Sp\u00f6rl - 2008\nExample program by c't 2008\nExample program translated to Java by unknown 2008\n\nAttention: start first c't-Mame (start button patch; german language) with the Asteroids game\nThen load the last generation\nSelect Infos -> Just Start Best\nSelect Infos -> Server Console -> \"Automatic\" OR \"Start One\"-> close window\nnow the game will automatically start");
    }

    public void open() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    private void CreateListener(Shell shell) {
        this.exitAdapter = new ExitAdapter();
        this.saveAdapter = new SaveAdapter(this.executionManager, shell);
        this.loadAdapter = new LoadAdapter(this.executionManager, shell);
        this.populationGenerateAdapter = new PopulationGenerateAdapter(this.population, this.generationGenerator);
        this.newAdapter = new NewAdapter(shell, this.populationGenerateAdapter);
        this.showPopulationAdapter = new ShowPopulationAdapter(shell);
        this.newServerAdapter = new NewServerAdapter(this.executionManager, shell);
        this.serverConsoleAdapter = this.executionManager != null ? new ServerConsoleAdapter(this.executionManager.getServer(0), shell) : new ServerConsoleAdapter(null, shell);
        this.serverListAdapter = new ServerListAdapter(this.executionManager, shell);
        this.justStartBestAdapter = new JustStartBestAdapter(this.executionManager);
        this.statisticAdapter = new StatisticAdapter(this.population, shell);
        this.mergeAdapter = new MergeAdapter(this.executionManager, this.createProgramTree, shell);
    }

    private void CreateMenuBar(Shell shell) {
        Menu menu = new Menu(shell, 2);
        shell.setMenuBar(menu);
        MenuItem menuItemFile = new MenuItem(menu, 64);
        menuItemFile.setText("File");
        Menu menuFile = new Menu(shell, 4);
        menuItemFile.setMenu(menuFile);
        MenuItem menuItemFileNew = new MenuItem(menuFile, 8);
        menuItemFileNew.setText("New");
        menuItemFileNew.addSelectionListener(this.newAdapter);
        MenuItem menuItemFileSave = new MenuItem(menuFile, 8);
        menuItemFileSave.setText("Save");
        menuItemFileSave.addSelectionListener(this.saveAdapter);
        MenuItem menuItemFileLoad = new MenuItem(menuFile, 8);
        menuItemFileLoad.setText("Load");
        menuItemFileLoad.addSelectionListener(this.loadAdapter);
        MenuItem menuItemFileMerge = new MenuItem(menuFile, 8);
        menuItemFileMerge.setText("Merge");
        menuItemFileMerge.addSelectionListener(this.mergeAdapter);
        MenuItem menuItemFileExit = new MenuItem(menuFile, 8);
        menuItemFileExit.setText("Exit");
        menuItemFileExit.addSelectionListener(this.exitAdapter);
        MenuItem menuItemInfos = new MenuItem(menu, 64);
        menuItemInfos.setText("Infos");
        Menu menuInfos = new Menu(shell, 4);
        menuItemInfos.setMenu(menuInfos);
        MenuItem menuItemInfosJustStartBest = new MenuItem(menuInfos, 32);
        menuItemInfosJustStartBest.setText("Just Start Best");
        menuItemInfosJustStartBest.addSelectionListener(this.justStartBestAdapter);
        MenuItem menuItemInfosPopulation = new MenuItem(menuInfos, 8);
        menuItemInfosPopulation.setText("Population");
        menuItemInfosPopulation.addSelectionListener(this.showPopulationAdapter);
        MenuItem menuItemInfosStatistic = new MenuItem(menuInfos, 8);
        menuItemInfosStatistic.setText("Statistic");
        menuItemInfosStatistic.addSelectionListener(this.statisticAdapter);
        MenuItem menuItemInfosServerList = new MenuItem(menuInfos, 8);
        menuItemInfosServerList.setText("Serverlist");
        menuItemInfosServerList.addSelectionListener(this.serverListAdapter);
        MenuItem menuItemInfosServer = new MenuItem(menuInfos, 8);
        menuItemInfosServer.setText("AddServer");
        menuItemInfosServer.addSelectionListener(this.newServerAdapter);
        MenuItem menuItemInfosServerConsole = new MenuItem(menuInfos, 8);
        menuItemInfosServerConsole.setText("Server Console");
        menuItemInfosServerConsole.addSelectionListener(this.serverConsoleAdapter);
    }

    public void setPopulation(GAPopulation newPopulation) {
        this.population = newPopulation;
        this.populationGenerateAdapter.setPopulation(this.population);
        this.showPopulationAdapter.setPopulation(this.population);
        this.statisticAdapter.setPopulation(this.population);
    }

    public void setGenerationGenerator(GAGenerationGenerator newGenerationGenerator) {
        this.generationGenerator = newGenerationGenerator;
        this.populationGenerateAdapter.setGenerationGenerator(this.generationGenerator);
    }

    public void setCreateProgramTree(CreateProgramTree newCreateProgramTree) {
        this.createProgramTree = newCreateProgramTree;
        this.loadAdapter.setCreateProgramTree(this.createProgramTree);
        this.mergeAdapter.setCreateProgramTree(this.createProgramTree);
    }

    public void setExecutionManager(ExecutionManager manager) {
        this.executionManager = manager;
        this.serverConsoleAdapter.setServerController(this.executionManager.getServer(0));
        this.serverListAdapter.setExecutionManager(manager);
        this.newServerAdapter.setExecutionManager(manager);
        this.loadAdapter.setExecutionManager(manager);
        this.saveAdapter.setExecutionManager(manager);
        this.justStartBestAdapter.setExecutionManager(manager);
        this.mergeAdapter.setExecutionManager(manager);
    }
}

