/*
 * Decompiled with CFR 0.152.
 */
package gui;

import global.CreateProgramTree;
import mainClasses.ExecutionManager;
import mainClasses.GALoad;
import mainClasses.GAPopulation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MergeAdapter
implements SelectionListener {
    private CreateProgramTree createProgramTree = null;
    private Shell shell = null;
    private ExecutionManager manager = null;

    public MergeAdapter(ExecutionManager manager, CreateProgramTree createProgramTree, Shell newShell) {
        this.manager = manager;
        this.createProgramTree = createProgramTree;
        this.shell = newShell;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    @Override
    public void widgetSelected(SelectionEvent arg0) {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setText("Merge");
        dialog.setFilterPath(".");
        dialog.setFilterExtensions(new String[]{"*.ga"});
        String filename = dialog.open();
        if (filename != null) {
            ExecutionManager tmpManager = new ExecutionManager();
            GAPopulation tmpPopulation = new GAPopulation();
            tmpManager.setPopulation(tmpPopulation);
            GALoad load = new GALoad();
            load.setCreateProgramTree(this.createProgramTree);
            load.load(filename, tmpManager);
            if (!this.manager.merge(tmpManager)) {
                Shell newWindowShell = new Shell(this.shell);
                newWindowShell.setText("Error");
                new Label(newWindowShell, 0).setText("Can't merge this two files");
                newWindowShell.pack();
                newWindowShell.open();
            }
        }
    }

    public void setCreateProgramTree(CreateProgramTree newCreateProgramTree) {
        this.createProgramTree = newCreateProgramTree;
    }

    public void setExecutionManager(ExecutionManager manager) {
        this.manager = manager;
    }
}

