/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import mainClasses.GAProgram;
import mainClasses.GASaveGraphViz;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProgramTreeAdapter
implements MouseListener {
    private Table table = null;

    public ProgramTreeAdapter(Table table, Shell newShell) {
        this.table = table;
    }

    @Override
    public void mouseDoubleClick(MouseEvent me) {
        String imgType = "gif";
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            TableItem item = this.table.getItem(index);
            GAProgram program = (GAProgram)item.getData();
            GASaveGraphViz saver = new GASaveGraphViz();
            String srcFile = "";
            try {
                srcFile = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String[] dirs = srcFile.split("/");
            srcFile = "";
            int i = 0;
            while (i < dirs.length - 1) {
                srcFile = String.valueOf(srcFile) + dirs[i] + "/";
                ++i;
            }
            saver.save(String.valueOf(srcFile) + "program.dot", program);
            String dotProgramPath = String.valueOf(srcFile) + "graphviz/bin/dot.exe";
            File file = new File(dotProgramPath);
            if (file.exists()) {
                try {
                    String cmd = String.valueOf(dotProgramPath) + " -T" + imgType + " " + srcFile.substring(1) + "program.dot" + " -o " + srcFile.substring(1) + "program." + imgType;
                    Process p = Runtime.getRuntime().exec(cmd);
                    p.waitFor();
                }
                catch (IOException cmd) {
                }
                catch (InterruptedException cmd) {
                    // empty catch block
                }
            }
            final Shell newWindowShell = new Shell(Display.getCurrent(), 1312752);
            newWindowShell.setText("Program");
            file = new File(String.valueOf(srcFile) + "program." + imgType);
            if (file.exists()) {
                final Image orgImage = new Image((Device)Display.getCurrent(), String.valueOf(srcFile) + "program." + imgType);
                final CurrentImage currentImage = new CurrentImage();
                currentImage.image = orgImage;
                final Point origin = new Point(0, 0);
                final ScrollBar hBar = newWindowShell.getHorizontalBar();
                hBar.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event e) {
                        int hSelection = hBar.getSelection();
                        int destX = -hSelection - origin.x;
                        Rectangle rect = currentImage.image.getBounds();
                        newWindowShell.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                        origin.x = -hSelection;
                    }
                });
                final ScrollBar vBar = newWindowShell.getVerticalBar();
                vBar.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event e) {
                        int vSelection = vBar.getSelection();
                        int destY = -vSelection - origin.y;
                        Rectangle rect = currentImage.image.getBounds();
                        newWindowShell.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                        origin.y = -vSelection;
                    }
                });
                newWindowShell.addListener(11, new Listener(){

                    @Override
                    public void handleEvent(Event e) {
                        Rectangle rect = currentImage.image.getBounds();
                        Rectangle client = newWindowShell.getClientArea();
                        hBar.setMaximum(rect.width);
                        vBar.setMaximum(rect.height);
                        hBar.setThumb(Math.min(rect.width, client.width));
                        vBar.setThumb(Math.min(rect.height, client.height));
                        int hPage = rect.width - client.width;
                        int vPage = rect.height = client.height;
                        int hSelection = hBar.getSelection();
                        int vSelection = vBar.getSelection();
                        if (hSelection >= hPage) {
                            if (hPage <= 0) {
                                hSelection = 0;
                            }
                            origin.x = -hSelection;
                        }
                        if (vSelection >= vPage) {
                            if (vPage <= 0) {
                                vSelection = 0;
                            }
                            origin.y = -vSelection;
                        }
                        newWindowShell.redraw();
                    }
                });
                newWindowShell.addListener(9, new Listener(){

                    @Override
                    public void handleEvent(Event e) {
                        int marginHeight;
                        GC gc = e.gc;
                        gc.drawImage(currentImage.image, origin.x, origin.y);
                        Rectangle rect = currentImage.image.getBounds();
                        Rectangle client = newWindowShell.getClientArea();
                        int marginWidth = client.width - rect.width;
                        if (marginWidth > 0) {
                            gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                        }
                        if ((marginHeight = client.height - rect.height) > 0) {
                            gc.fillRectangle(0, rect.height, client.width, marginHeight);
                        }
                    }
                });
                newWindowShell.addKeyListener(new KeyListener(){
                    private int zoom = 100;

                    @Override
                    public void keyPressed(KeyEvent e) {
                        int oldZoom = this.zoom;
                        if (e.character == '+') {
                            this.zoom += 10;
                        }
                        if (e.character == '-') {
                            this.zoom -= 10;
                        }
                        if (this.zoom < 10) {
                            this.zoom = 10;
                        }
                        if (this.zoom > 200) {
                            this.zoom = 200;
                        }
                        int width = orgImage.getBounds().width / 100 * this.zoom;
                        int height = orgImage.getBounds().height / 100 * this.zoom;
                        currentImage.image = new Image((Device)Display.getCurrent(), width, height);
                        GC gc = new GC(currentImage.image);
                        gc.drawImage(orgImage, 0, 0, orgImage.getBounds().width, orgImage.getBounds().height, 0, 0, width, height);
                        gc.dispose();
                        hBar.setMaximum(width);
                        vBar.setMaximum(height);
                        Rectangle client = newWindowShell.getClientArea();
                        hBar.setThumb(Math.min(width, client.width));
                        vBar.setThumb(Math.min(height, client.height));
                        int h = hBar.getSelection() * 100 / oldZoom / 100 * this.zoom;
                        int v = vBar.getSelection() * 100 / oldZoom / 100 * this.zoom;
                        hBar.setSelection(h);
                        vBar.setSelection(v);
                        newWindowShell.scroll(h, v, 0, 0, width, height, true);
                        newWindowShell.redraw();
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }
                });
            }
            newWindowShell.pack();
            newWindowShell.pack();
            newWindowShell.open();
        }
    }

    @Override
    public void mouseDown(MouseEvent e) {
    }

    @Override
    public void mouseUp(MouseEvent e) {
    }

    private class CurrentImage {
        public Image image = null;

        private CurrentImage() {
        }
    }
}

