/*
 * Decompiled with CFR 0.152.
 */
package gui;

import mainClasses.ServerController;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ServerConsoleComposite
extends Composite {
    private ServerController controller = null;
    private Label serverStatusLabel = null;
    private Text serverNameText = null;

    public ServerConsoleComposite(Composite parent, ServerController controller, int style) {
        super(parent, style);
        this.controller = controller;
        this.setLayout(new GridLayout(1, false));
        Label labelLabelStatus = new Label(this, 0);
        labelLabelStatus.setText("Server Status:");
        labelLabelStatus.setLayoutData(new GridData(256));
        this.serverStatusLabel = new Label(this, 0);
        this.serverStatusLabel.setText("UNKNOWN UNKNOWN UNKNOWN");
        this.serverStatusLabel.setLayoutData(new GridData(256));
        Label labelGameServerName = new Label(this, 0);
        labelGameServerName.setText("Game server name:");
        labelGameServerName.setLayoutData(new GridData(256));
        this.serverNameText = new Text(this, 2048);
        this.serverNameText.setText("localhost");
        this.serverNameText.setLayoutData(new GridData(256));
        Composite compositeButtonList = new Composite(this, 0);
        compositeButtonList.setLayout(new RowLayout());
        Button getStatusButton = new Button(compositeButtonList, 2048);
        getStatusButton.setText(" Status ");
        getStatusButton.addSelectionListener(new ServerStatusAdapter(this.controller, this.serverStatusLabel));
        Button shutdownButton = new Button(compositeButtonList, 2048);
        shutdownButton.setText(" Shutdown ");
        shutdownButton.addSelectionListener(new ShutdownAdapter(this.controller));
        Button automaticButton = new Button(compositeButtonList, 2048);
        automaticButton.setText(" Automatic ");
        automaticButton.addSelectionListener(new AutomaticStatusAdapter(this.controller));
        Button manualButton = new Button(compositeButtonList, 2048);
        manualButton.setText(" Manual ");
        manualButton.addSelectionListener(new ManualStatusAdapter(this.controller));
        Button startOneButton = new Button(compositeButtonList, 2048);
        startOneButton.setText(" Start One ");
        startOneButton.addSelectionListener(new StartOneStatusAdapter(this.controller));
        Button settingButton = new Button(compositeButtonList, 2048);
        settingButton.setText(" Send settings ");
        settingButton.addSelectionListener(new SendSettingAdapter(this.controller));
        compositeButtonList.pack();
        this.pack();
    }

    private class AutomaticStatusAdapter
    implements SelectionListener {
        private ServerController controller = null;

        public AutomaticStatusAdapter(ServerController controller) {
            this.controller = controller;
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            this.controller.activateAutomaticMode();
        }
    }

    private class ManualStatusAdapter
    implements SelectionListener {
        private ServerController controller = null;

        public ManualStatusAdapter(ServerController controller) {
            this.controller = controller;
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            this.controller.activateManualMode();
        }
    }

    private class SendSettingAdapter
    implements SelectionListener {
        private ServerController controller = null;

        public SendSettingAdapter(ServerController controller) {
            this.controller = controller;
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            this.controller.sendSetting(ServerConsoleComposite.this.serverNameText.getText());
        }
    }

    private class ServerStatusAdapter
    implements SelectionListener {
        private ServerController controller = null;
        private Label statusLabel = null;

        public ServerStatusAdapter(ServerController controller, Label label) {
            this.controller = controller;
            this.statusLabel = label;
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            String txt = String.valueOf(this.controller.getServerStatus()) + " \t\t ";
            switch (this.controller.getStatus()) {
                case DOWN: {
                    txt = String.valueOf(txt) + "[DOWN]";
                    break;
                }
                case MANUAL: {
                    txt = String.valueOf(txt) + "[MANUAL]";
                    break;
                }
                case AUTOMATIC: {
                    txt = String.valueOf(txt) + "[AUTOMATIC]";
                }
            }
            this.statusLabel.setText(txt);
        }
    }

    private class ShutdownAdapter
    implements SelectionListener {
        private ServerController controller = null;

        public ShutdownAdapter(ServerController controller) {
            this.controller = controller;
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            this.controller.sendShutdown();
        }
    }

    private class StartOneStatusAdapter
    implements SelectionListener {
        private ServerController controller = null;

        public StartOneStatusAdapter(ServerController controller) {
            this.controller = controller;
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            this.controller.activateStartOneMode();
        }
    }
}

