/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.Comparator;
import mainClasses.GAPopulation;
import mainClasses.GAStatistic;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StatisticAdapter
implements SelectionListener {
    private Shell parentShell = null;
    private Shell newWindowShell = null;
    private GAPopulation population = null;

    public StatisticAdapter(GAPopulation population, Shell theParentShell) {
        this.parentShell = theParentShell;
        this.population = population;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    @Override
    public void widgetSelected(SelectionEvent arg0) {
        this.newWindowShell = new Shell(this.parentShell);
        this.newWindowShell.setText("Statistics");
        this.newWindowShell.setLayout(new FillLayout());
        Text text = new Text(this.newWindowShell, 2826);
        String txt = "";
        if (this.population != null) {
            GAStatistic stat = new GAStatistic(this.population);
            txt = String.valueOf(txt) + stat.getText("size\t\t\t", stat.getPopulationSize(), " programs(s)", -1, "no population");
            txt = String.valueOf(txt) + stat.getText("generation\t\t", stat.getGeneration(), ". generation(s)", -1, "no population");
            txt = String.valueOf(txt) + stat.getText("max\t\t\t", stat.getMaxPoints(), " point(s)", -1, "no program rated");
            txt = String.valueOf(txt) + "max single\t\t = " + stat.getVText(stat.getMaxRating(), " point(s)", -1, "no program rated") + " [" + stat.getVText(stat.getMaxRating() * 3, " point(s)", -1, "no program rated") + "]\n";
            txt = String.valueOf(txt) + stat.getText("min\t\t\t\t", stat.getMinPoints(), " point(s)", -1, "no program rated");
            txt = String.valueOf(txt) + stat.getText("average\t\t", (int)stat.getAveragePoints(), " point(s)", -1, "no program rated");
            txt = String.valueOf(txt) + stat.getText("std. derivation\t", (int)stat.getStandardDeviation(), " point(s)", -1, "too less programs rated");
            txt = String.valueOf(txt) + "percent done\t = " + stat.getVText((int)(stat.getPercentDone() * 100.0), "%", -1, "population size 0") + " (" + stat.getVText(stat.getRatedProgramCount(), "", -1, "no program rated") + "/" + stat.getVText(stat.getPopulationSize(), "", -1, "population size 0") + ")\n";
            txt = String.valueOf(txt) + stat.getText("started\t\t\t", stat.getCurrentStartedProgramCount(), " program(s)", -1, "error");
            txt = String.valueOf(txt) + stat.getText("min depth\t\t", stat.getMinProgramDepth(), "", -1, "error");
            txt = String.valueOf(txt) + stat.getText("max depth\t\t", stat.getMaxProgramDepth(), "", -1, "error");
            txt = String.valueOf(txt) + "\n";
            txt = String.valueOf(txt) + stat.getText("median\t\t\t", stat.getMedian(), " point(s)", -1, "no program rated");
            txt = String.valueOf(txt) + "\t\t\t\t = " + stat.getVText(stat.getMedian(-5), "; ", -1, "") + stat.getVText(stat.getMedian(-4), "; ", -1, "") + stat.getVText(stat.getMedian(-3), "; ", -1, "") + stat.getVText(stat.getMedian(-2), "; ", -1, "") + stat.getVText(stat.getMedian(-1), "", -1, "") + " | " + stat.getVText(stat.getMedian(1), "; ", -1, "") + stat.getVText(stat.getMedian(2), "; ", -1, "") + stat.getVText(stat.getMedian(3), "; ", -1, "") + stat.getVText(stat.getMedian(4), "; ", -1, "") + stat.getVText(stat.getMedian(5), "", -1, "") + "\n";
            txt = String.valueOf(txt) + "worst 25%\t\t <= " + stat.getVText(stat.getMedian(0.25f), " point(s)", -1, "too less programs rated") + "\n";
            txt = String.valueOf(txt) + "best 25%\t\t >= " + stat.getVText(stat.getMedian(0.75f), " point(s)", -1, "too less programs rated") + "\n";
            txt = String.valueOf(txt) + stat.getText("aver. t50%\t", stat.getAverage(0.5f, 1.0f), " point(s)", -1, "too less programs rated");
            txt = String.valueOf(txt) + "\n";
            int lastEnd = 0;
            int i = 0;
            while (i < stat.getPointRangeCount()) {
                GAStatistic.PointRangeItem item = stat.getPointRangeItem(i);
                if (lastEnd + 1 < item.start) {
                    txt = String.valueOf(txt) + "--------------------\n";
                }
                String title = String.valueOf(item.start) + " - " + item.end;
                txt = String.valueOf(txt) + title + (title.length() < 8 ? "\t" : "") + (title.length() < 10 ? "\t" : "") + "\t\t = " + item.count + " \t (" + item.count * 100 / stat.getRatedProgramCount() + "%)";
                txt = String.valueOf(txt) + "\t " + (int)((double)item.sum / (double)stat.getSinglePointSum() * 100.0) + "%\n";
                lastEnd = item.end;
                ++i;
            }
        } else {
            txt = String.valueOf(txt) + "first load population";
        }
        text.setText(txt);
        this.newWindowShell.open();
    }

    public void setPopulation(GAPopulation newPopulation) {
        this.population = newPopulation;
    }

    private class StatisticItem {
        public int start = 0;
        public int end = 0;
        public int count = 0;
        public int sum = 0;

        private StatisticItem() {
        }
    }

    public class StatisticItemComparator
    implements Comparator<StatisticItem> {
        @Override
        public int compare(StatisticItem arg0, StatisticItem arg1) {
            if (arg0.start < arg1.start) {
                return -1;
            }
            if (arg0.start > arg1.start) {
                return 1;
            }
            return 0;
        }
    }
}

