/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.Semaphore;
import mainClasses.GANextGenerationGenerator;
import mainClasses.GAPopulation;
import mainClasses.GAProgram;
import mainClasses.GASave;
import mainClasses.ServerController;

public class ExecutionManager
extends Thread {
    private List<ServerController> serverList = null;
    private GAPopulation population = null;
    private GANextGenerationGenerator nextGenerator = null;
    private Semaphore nextProgramSemaphore = null;
    private Random random = null;
    private String filename = "";
    private GASave saver = null;
    private boolean justStartBest = false;
    private int justStartNumber = -1;
    private StartingDirection startingDirection = StartingDirection.FORWARD;
    private String identifier = "";

    public ExecutionManager() {
        this.serverList = new ArrayList<ServerController>();
        this.nextProgramSemaphore = new Semaphore(1);
        this.random = new Random();
        this.identifier = this.createIdentifier();
    }

    public void addServer(ServerController addServer) {
        this.serverList.add(addServer);
    }

    public GAPopulation setPopulation(GAPopulation population) {
        this.population = population;
        return this.population;
    }

    public GAPopulation getPopulation() {
        return this.population;
    }

    public GAProgram getNextProgram(GAProgram prev) {
        if (this.justStartBest) {
            return this.getBestProgram();
        }
        if (this.justStartNumber > -1) {
            return this.getProgramNumber();
        }
        if (prev != null && prev.isStarted()) {
            return prev;
        }
        GAProgram ret = null;
        try {
            this.nextProgramSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ret = this.getNextUnratedUnstartedProgram(prev, true);
        if (ret != null) {
            this.createIdentifier(ret);
            ret.setStarted();
        } else if (this.generationFinished()) {
            this.createNextGeneration();
            ret = this.getNextUnratedUnstartedProgram(prev, true);
            if (ret != null) {
                this.createIdentifier(ret);
                ret.setStarted();
            }
        } else {
            ret = this.getNextUnratedUnstartedProgram(prev, false);
            if (ret != null) {
                this.createIdentifier(ret);
                ret.setStarted();
            }
        }
        this.nextProgramSemaphore.release();
        return ret;
    }

    private GAProgram getBestProgram() {
        if (this.population == null) {
            return null;
        }
        GAProgram best = null;
        int i = 0;
        while (i < this.population.getSize()) {
            GAProgram program = this.population.get(i);
            if (best == null) {
                best = program;
            } else if (best.getRating() < program.getRating()) {
                best = program;
            }
            ++i;
        }
        return best;
    }

    private GAProgram getProgramNumber() {
        if (this.population == null) {
            return null;
        }
        if (this.justStartNumber < this.population.getSize()) {
            return this.population.get(this.justStartNumber);
        }
        return null;
    }

    private boolean generationFinished() {
        if (this.population == null) {
            return true;
        }
        int i = 0;
        while (i < this.population.getSize()) {
            GAProgram program = this.population.get(i);
            if (program.getRating() < 0 || program.isStarted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void createNextGeneration() {
        if (this.population == null) {
            return;
        }
        if (this.population.getSize() <= 0) {
            return;
        }
        if (this.population.getSize() > 0 && this.saver != null && !this.filename.equals("")) {
            this.saver.save(String.valueOf(this.filename) + ".g" + this.population.getGeneration() + ".ga", this);
        }
        Date d = new Date();
        DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
        if (this.nextGenerator != null) {
            System.out.println(String.valueOf(df.format(d)) + " ExecutionManager.createNextGeneration(): create next generation");
            this.population.sortPopulation();
            this.nextGenerator.createNextGeneration(this.population);
        } else {
            System.out.println(String.valueOf(df.format(d)) + " ExecutionManager.createNextGeneration(): ERROR: no generator");
        }
        if (this.population.getSize() > 0 && this.saver != null && !this.filename.equals("")) {
            String tmpFilename;
            File file;
            while ((file = new File(tmpFilename = String.valueOf(this.filename) + ".g" + this.population.getGeneration() + ".ga")).exists()) {
                this.filename = String.valueOf(this.filename) + ".g" + this.population.getGeneration();
            }
            this.saver.save(tmpFilename, this);
        }
    }

    private boolean isFinished(StartingDirection startingDirection, int end, int i) {
        if (startingDirection == StartingDirection.FORWARD) {
            return i < end;
        }
        return i > end;
    }

    private GAProgram getNextUnratedUnstartedProgram(GAProgram prev, boolean checkPrev) {
        if (this.population == null) {
            return null;
        }
        Date d = new Date();
        DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
        int start = 0;
        int end = 0;
        int increment = 1;
        switch (this.startingDirection) {
            case FORWARD: {
                start = 0;
                end = this.population.getSize();
                increment = 1;
                break;
            }
            case BACKWARD: {
                start = this.population.getSize() - 1;
                end = -1;
                increment = -1;
            }
        }
        int i = start;
        while (this.isFinished(this.startingDirection, end, i)) {
            GAProgram program = this.population.get(i);
            if (program != null) {
                if (program.getRating() < 0 && !program.isStarted()) {
                    if (checkPrev) {
                        if (program != prev) {
                            System.out.println(String.valueOf(df.format(d)) + " ExecutionManager.getNextUnratedUnstartedProgram: (1) " + i + ".");
                            return program;
                        }
                    } else {
                        System.out.println(String.valueOf(df.format(d)) + " ExecutionManager.getNextUnratedUnstartedProgram: (2) " + i + ".");
                        return program;
                    }
                }
                if (program.getTimeout() < d.getTime() && program.isStarted()) {
                    program.setNotStarted();
                }
            }
            i += increment;
        }
        return null;
    }

    public ServerController getServer(int i) {
        if (this.serverList != null) {
            return this.serverList.get(i);
        }
        return null;
    }

    public int getServerCount() {
        if (this.serverList != null) {
            return this.serverList.size();
        }
        return 0;
    }

    private String createIdentifier() {
        String letters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String newIdentifier = "";
        int i = 0;
        while (i < 32) {
            int pos = this.random.nextInt(letters.length());
            newIdentifier = String.valueOf(newIdentifier) + letters.charAt(pos);
            ++i;
        }
        return newIdentifier;
    }

    private void createIdentifier(GAProgram program) {
        program.setIdentifier(this.createIdentifier());
    }

    public void setRatingFinished(String identifier, int rating) {
        if (this.population == null) {
            return;
        }
        if (this.justStartBest || this.justStartNumber > -1) {
            return;
        }
        try {
            this.nextProgramSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.population.setRating(identifier, rating);
        if (this.population.getSize() > 0 && this.saver != null && !this.filename.equals("")) {
            this.saver.save(String.valueOf(this.filename) + ".g" + this.population.getGeneration() + ".ga", this);
        }
        this.nextProgramSemaphore.release();
    }

    public GANextGenerationGenerator setNextGenerationGenerator(GANextGenerationGenerator generator) {
        this.nextGenerator = generator;
        return this.nextGenerator;
    }

    public GANextGenerationGenerator getNextGenerationGenerator() {
        return this.nextGenerator;
    }

    public void doShutdown() {
        int i = 0;
        while (i < this.serverList.size()) {
            this.serverList.get(i).doShutdown();
            ++i;
        }
    }

    public String setFilename(String filename) {
        this.filename = filename;
        if (this.filename.endsWith(".ga")) {
            this.filename = this.filename.substring(0, this.filename.length() - 3);
        }
        int index = this.filename.lastIndexOf(".g");
        try {
            Integer.valueOf(this.filename.substring(index + 2, this.filename.length()));
            this.filename = this.filename.substring(0, index);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.filename;
    }

    public void setSaver(GASave saver) {
        this.saver = saver;
    }

    public void setJustStartBest(boolean doit) {
        this.justStartBest = doit;
    }

    public boolean getJustStartBest() {
        return this.justStartBest;
    }

    public int setJustStartNumber(int number) {
        this.justStartNumber = number;
        return this.justStartNumber;
    }

    public int getJustStartNumber() {
        return this.justStartNumber;
    }

    public StartingDirection setStartingDirection(StartingDirection startingDirection) {
        this.startingDirection = startingDirection;
        return this.startingDirection;
    }

    public StartingDirection getStartingDirection() {
        return this.startingDirection;
    }

    public boolean merge(ExecutionManager second) {
        GAPopulation popSecond = second.getPopulation();
        if (this.population.getSize() != popSecond.getSize()) {
            return false;
        }
        int size = this.population.getSize();
        int i = 0;
        while (i < size) {
            String programSecond;
            String programFirst = this.population.get(i).getProgramString();
            if (!programFirst.equals(programSecond = popSecond.get(i).getProgramString())) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            GAProgram progFirst = this.population.get(i);
            if (progFirst.getRating() < 0) {
                GAProgram progSecond = popSecond.get(i);
                int j = 0;
                while (j < progSecond.getCurrentRatingCount()) {
                    progFirst.addRating(progSecond.getSubRating(j));
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static enum StartingDirection {
        FORWARD,
        BACKWARD;

    }
}

