/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import commands.AICommand;
import global.CreateProgramTree;
import java.util.ArrayList;
import java.util.Random;
import mainClasses.GALibrary;
import mainClasses.GAPopulation;
import mainClasses.GAProgram;
import mainClasses.GAProgramGenerator;

public class GANextGenerationGenerator {
    private Random random = null;
    private GAProgramGenerator programGenerator = null;
    private CreateProgramTree creater = null;
    private boolean newNodeSelectionMethod = false;
    private double acceptRate = 0.01;
    private double mutationRate = 0.001;
    private double libraryRate = 0.0;
    private int maxProgramDepth = 45;
    private int maxLibraryDepth = 10;
    private GALibrary library = null;

    public GANextGenerationGenerator(Random random, GAProgramGenerator cpt) {
        this.random = random;
        this.programGenerator = cpt;
    }

    public void createNextGeneration(GAPopulation population) {
        GAProgram program;
        if (this.random == null) {
            return;
        }
        if (population == null) {
            return;
        }
        if (population.getSize() <= 0) {
            return;
        }
        ArrayList<GAProgram> next = new ArrayList<GAProgram>();
        int populationSize = population.getSize();
        int count = (int)(this.acceptRate * (double)populationSize);
        int i = 0;
        while (i < count) {
            program = new GAProgram();
            program.setCreateProgramTree(this.creater);
            AICommand root = (AICommand)population.get(populationSize - i - 1).getProgram();
            program.setProgram(root.copy());
            program.setNotStarted();
            if (program != null) {
                next.add(program);
            }
            ++i;
        }
        int ratingSum = this.getRatingSum(population, populationSize);
        while (next.size() < populationSize) {
            if ((double)this.random.nextFloat() < this.mutationRate) {
                program = this.doMutation(population, populationSize, ratingSum);
                if (program == null || ((AICommand)program.getProgram()).getProgramDepth() >= this.maxProgramDepth) continue;
                next.add(program);
                continue;
            }
            program = this.doCrossOver(population, populationSize, ratingSum);
            if (program == null || ((AICommand)program.getProgram()).getProgramDepth() >= this.maxProgramDepth) continue;
            next.add(program);
        }
        count = (int)(this.libraryRate * (double)populationSize);
        int i2 = 0;
        while (i2 < count) {
            GAProgram ret = population.get(this.random.nextInt(populationSize));
            AICommand[] selNodeA = null;
            while (this.maxLibraryDepth > (selNodeA = this.CrossOverSelectNode((AICommand)ret.getProgram(), false, -1, -1))[1].getProgramDepth()) {
            }
            ++i2;
        }
        population.clear();
        population.addAllPrograms(next);
        population.setGeneration(population.getGeneration() + 1);
    }

    private GAProgram doCrossOver(GAPopulation population, int populationSize, int ratingSum) {
        GAProgram selectedA = this.selectRandomProgram(population, populationSize, ratingSum);
        GAProgram selectedB = this.selectRandomProgram(population, populationSize, ratingSum);
        System.out.println("GANextGenGenerator.doCrossOver: ProgA: " + selectedA.getRating());
        System.out.println("GANextGenGenerator.doCrossOver: ProgB: " + selectedB.getRating());
        System.out.println("GANextGenGenerator.doCrossOver: -------------------------------");
        AICommand rootA = (AICommand)((AICommand)selectedA.getProgram()).copy();
        AICommand rootB = (AICommand)((AICommand)selectedB.getProgram()).copy();
        AICommand[] selNodeA = this.CrossOverSelectNode(rootA, false, -1, -1);
        AICommand[] selNodeB = null;
        if (selNodeA[1] != null) {
            selNodeB = this.CrossOverSelectNode(rootB, true, -1, -1);
        }
        if (selNodeA[1] != null) {
            int i = 0;
            while (i < selNodeA[0].getCurrentParameterCount()) {
                if (selNodeA[0].getParameter(i) == selNodeA[1]) {
                    selNodeA[0].setParameter(i, selNodeB[1]);
                    break;
                }
                ++i;
            }
            GAProgram ret = new GAProgram();
            ret.setCreateProgramTree(this.creater);
            ret.setProgram(rootA);
            ret.setNotStarted();
            return ret;
        }
        return null;
    }

    private GAProgram doMutation(GAPopulation population, int populationSize, int ratingSum) {
        if (this.programGenerator == null) {
            return null;
        }
        GAProgram selectedA = this.selectRandomProgram(population, populationSize, ratingSum);
        System.out.println("GANextGenGenerator.doMutation : ProgA: " + selectedA.getRating());
        System.out.println("GANextGenGenerator.doCrossOver: -------------------------------");
        AICommand rootA = (AICommand)((AICommand)selectedA.getProgram()).copy();
        AICommand[] selNodeA = this.CrossOverSelectNode(rootA, false, -1, -1);
        if (selNodeA[1] != null) {
            int i = 0;
            while (i < selNodeA[0].getCurrentParameterCount()) {
                if (selNodeA[0].getParameter(i) == selNodeA[1]) {
                    int depth = selNodeA[1].getProgramDepth() + this.random.nextInt(3) - 1;
                    selNodeA[0].setParameter(i, (AICommand)this.programGenerator.generate(depth, false));
                    break;
                }
                ++i;
            }
            GAProgram ret = new GAProgram();
            ret.setCreateProgramTree(this.creater);
            ret.setProgram(rootA);
            ret.setNotStarted();
            return ret;
        }
        return null;
    }

    private AICommand[] CrossOverSelectNode(AICommand root, boolean rootPossible, int minDepth, int maxDepth) {
        AICommand[] selectNode = new AICommand[]{null, root};
        int depth = 0;
        while (true) {
            int select;
            ++depth;
            if (selectNode[0] == null && !rootPossible) {
                if (selectNode[1].getCurrentParameterCount() > 0) {
                    select = this.random.nextInt(this.getParamRandomNumber(selectNode[1]));
                    selectNode[0] = selectNode[1];
                    selectNode[1] = this.getParamFromRandomNumber(selectNode[0], select);
                    continue;
                }
                selectNode[0] = selectNode[1];
                selectNode[1] = null;
                break;
            }
            select = this.random.nextInt(this.getParamRandomNumber(selectNode[1]) + depth);
            if (select < depth) break;
            selectNode[0] = selectNode[1];
            selectNode[1] = this.getParamFromRandomNumber(selectNode[0], select - depth);
        }
        return selectNode;
    }

    private int getParamRandomNumber(AICommand Node2) {
        if (this.newNodeSelectionMethod) {
            return (Node2.getProgramDepth() - 1) * Node2.getCurrentParameterCount();
        }
        int tmp = 0;
        int i = 0;
        while (i < Node2.getCurrentParameterCount()) {
            tmp += ((AICommand)Node2.getParameter(i)).getProgramDepth();
            ++i;
        }
        return tmp;
    }

    private AICommand getParamFromRandomNumber(AICommand Node2, int number) {
        if (this.newNodeSelectionMethod) {
            AICommand ret = null;
            int max = Node2.getProgramDepth() - 1;
            int i = 0;
            while (i < Node2.getCurrentParameterCount()) {
                if ((number -= max) < 0) {
                    ret = (AICommand)Node2.getParameter(i);
                    break;
                }
                ++i;
            }
            return ret;
        }
        AICommand ret = null;
        int i = 0;
        while (i < Node2.getCurrentParameterCount()) {
            if ((number -= ((AICommand)Node2.getParameter(i)).getProgramDepth()) < 0) {
                ret = (AICommand)Node2.getParameter(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    private int getRatingSum(GAPopulation population, int populationSize) {
        int ratingSum = 0;
        int i = 0;
        while (i < populationSize) {
            ratingSum += population.get(i).getRating();
            ++i;
        }
        return ratingSum;
    }

    private GAProgram selectRandomProgram(GAPopulation population, int populationSize, int ratingSum) {
        GAProgram ret = null;
        int r = this.random.nextInt(ratingSum);
        int j = 0;
        while (j < populationSize) {
            if ((r -= population.get(j).getRating()) < 0) {
                ret = population.get(j);
                break;
            }
            ++j;
        }
        return ret;
    }

    public void setCreateProgramTree(CreateProgramTree cpt) {
        this.creater = cpt;
    }

    public CreateProgramTree getCreateProgramTree() {
        return this.creater;
    }

    public GALibrary setLibrary(GALibrary library) {
        this.library = library;
        return this.library;
    }

    public GALibrary getLibrary() {
        return this.library;
    }

    public int setMaxProgramDepth(int depth) {
        this.maxProgramDepth = depth;
        return this.maxProgramDepth;
    }

    public int getMaxProgramDepth() {
        return this.maxProgramDepth;
    }

    public int setMaxLibraryDepth(int depth) {
        this.maxLibraryDepth = depth;
        return this.maxLibraryDepth;
    }

    public int getMaxLibraryDepth() {
        return this.maxLibraryDepth;
    }

    public double setMutationRate(double rate) {
        this.mutationRate = rate;
        return this.mutationRate;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public double setLibraryRate(double rate) {
        this.libraryRate = rate;
        return this.libraryRate;
    }

    public double getLibraryRate() {
        return this.libraryRate;
    }

    public double setAcceptRate(double rate) {
        this.acceptRate = rate;
        return this.acceptRate;
    }

    public double getAcceptRate() {
        return this.acceptRate;
    }
}

