/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import mainClasses.GAProgram;

public class GAPopulation {
    private List<GAProgram> population = new ArrayList<GAProgram>();
    private int generation = 0;
    private boolean blocked = false;
    private int ratingCount = 5;
    private int maxRating = 5000;

    public void block() {
        this.blocked = true;
    }

    public void unblock() {
        this.blocked = false;
    }

    public void addProgram(GAProgram toAdd) {
        this.population.add(toAdd);
    }

    public void addAllPrograms(List<GAProgram> toAdd) {
        this.population.addAll(toAdd);
    }

    public void clear() {
        this.population.clear();
    }

    public int getSize() {
        return this.population.size();
    }

    public GAProgram get(int i) {
        if (!this.blocked) {
            return this.population.get(i);
        }
        return null;
    }

    public int setGeneration(int newGeneration) {
        this.generation = newGeneration;
        return this.generation;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void sortPopulation() {
        Collections.sort(this.population, new RatingComparator());
    }

    public void setRating(String identifier, int rating) {
        Date d = new Date();
        DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
        int i = 0;
        while (i < this.getSize()) {
            GAProgram program = this.population.get(i);
            if (program.getIdentifier().equals(identifier) && program.getRating() < 0 && program.isStarted()) {
                program.setFinished();
                program.setRatingCount(this.ratingCount);
                this.maxRating = rating < this.maxRating * 3 ? (rating > this.maxRating ? rating : this.maxRating) : this.maxRating;
                program.setMaxRating(this.maxRating);
                program.addRating(rating);
                String txt = "GAPopulation.setRating(): " + i + ". " + rating + " points";
                txt = program.getRating() > -1 ? String.valueOf(txt) + " => " + program.getRating() + " points" : String.valueOf(txt) + " => rating not finished";
                System.out.println(String.valueOf(df.format(d)) + " " + txt);
            }
            ++i;
        }
    }

    public int setRatingCount(int ratingCount) {
        this.ratingCount = ratingCount;
        return this.ratingCount;
    }

    public int getRatingCount() {
        return this.ratingCount;
    }

    public int setMaxRating(int maxRating) {
        this.maxRating = maxRating;
        return this.maxRating;
    }

    public int getMaxRating() {
        return this.maxRating;
    }

    public class RatingComparator
    implements Comparator<GAProgram> {
        @Override
        public int compare(GAProgram arg0, GAProgram arg1) {
            if (arg0.getRating() < arg1.getRating()) {
                return -1;
            }
            if (arg0.getRating() > arg1.getRating()) {
                return 1;
            }
            return 0;
        }
    }
}

