/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import commands.AICommand;
import commands.IAICommand;
import global.CreateProgramTree;
import java.util.ArrayList;
import java.util.List;

public class GAProgram {
    private int rating = -1;
    private int ratingCount = 5;
    private List<Integer> ratings = new ArrayList<Integer>();
    private CreateProgramTree creater = null;
    private IAICommand program = null;
    private String programString = "";
    private boolean running = false;
    private String identifier = "";
    private long timeout = 0L;
    private boolean blocked = false;
    public int maxRating = 5000;

    public IAICommand setProgram(IAICommand root) {
        if (this.creater == null) {
            this.program = root;
            return this.program;
        }
        this.programString = ((AICommand)root).getString();
        return root;
    }

    public IAICommand getProgram() {
        if (!this.programString.isEmpty() && this.creater != null) {
            return this.creater.interpret(this.programString);
        }
        return this.program;
    }

    public int setRating(int newRating) {
        this.maxRating = newRating > this.maxRating ? newRating : this.maxRating;
        this.rating = newRating;
        this.ratings = new ArrayList<Integer>();
        return this.rating;
    }

    public void addRating(int newRating) {
        if (newRating > this.maxRating * 3) {
            return;
        }
        if (this.ratings.size() < this.ratingCount) {
            this.ratings.add(new Integer(newRating));
        }
        if (this.ratings.size() >= this.ratingCount) {
            int sum = 0;
            int min = 200000000;
            int max = 0;
            int i = 0;
            while (i < this.ratings.size()) {
                sum += this.ratings.get(i).intValue();
                if (min > this.ratings.get(i)) {
                    min = this.ratings.get(i);
                }
                if (max < this.ratings.get(i)) {
                    max = this.ratings.get(i);
                }
                ++i;
            }
            this.rating = ((sum - min - max) * 2 + min + max) / ((this.ratingCount - 2) * 2 + 2);
        }
    }

    public int getRating() {
        return this.rating;
    }

    public int getCurrentRatingCount() {
        return this.ratings.size();
    }

    public int getSubRating(int i) {
        if (i < this.ratings.size()) {
            return this.ratings.get(i);
        }
        return -1;
    }

    public String getProgramString() {
        if (this.program != null) {
            return ((AICommand)this.program).getString();
        }
        return this.programString;
    }

    public boolean isStarted() {
        return this.running;
    }

    public void setStarted() {
        this.running = true;
    }

    public void setFinished() {
        this.running = false;
    }

    public void setNotStarted() {
        this.running = false;
    }

    public String setIdentifier(String identifier) {
        this.identifier = identifier;
        return this.identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public long setTimeout(long timeout) {
        this.timeout = timeout;
        return timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setCreateProgramTree(CreateProgramTree cpt) {
        this.creater = cpt;
    }

    public CreateProgramTree getCreateProgramTree() {
        return this.creater;
    }

    public boolean getBlockedStatus() {
        return this.blocked;
    }

    public boolean setBlockedStatus(boolean blocked) {
        this.blocked = blocked;
        return this.blocked;
    }

    public int setRatingCount(int ratingCount) {
        this.ratingCount = ratingCount;
        return this.ratingCount;
    }

    public int setMaxRating(int maxRating) {
        this.maxRating = maxRating;
        return this.maxRating;
    }
}

