/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import commands.AICommand;
import commands.IAICommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mainClasses.GAProgram;

public class GAProgramGenerator {
    private List<IAICommand> commandList = new ArrayList<IAICommand>();
    private List<IAICommand> terminalCommands = null;
    private List<IAICommand> nodeCommands = null;
    private Random random = null;
    private int maxdepth = 0;
    private boolean fill = false;

    public GAProgramGenerator() {
    }

    public GAProgramGenerator(int newMaxDepth, boolean newFill) {
        this.maxdepth = newMaxDepth;
        this.fill = newFill;
    }

    public void addCommand(IAICommand command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public void addCommands(List<IAICommand> list) {
        int i = 0;
        while (i < list.size()) {
            this.commandList.add(list.get(i));
            ++i;
        }
    }

    public void clearCommandList() {
        this.commandList.clear();
    }

    public Random setRandom(Random newRandom) {
        this.random = newRandom;
        return this.random;
    }

    public int setMaxDepth(int newMaxDepth) {
        this.maxdepth = newMaxDepth;
        return this.maxdepth;
    }

    public boolean setFill(boolean newFill) {
        this.fill = newFill;
        return this.fill;
    }

    public void generate(GAProgram program) {
        this.generate(program, this.maxdepth, this.fill);
    }

    public void generate(GAProgram program, int maxdepth, boolean fill) {
        if (this.random == null) {
            this.random = new Random();
        }
        if (program != null && this.commandList != null && this.commandList.size() > 0) {
            this.createTerminalCommandList();
            this.createNodeCommandList();
            program.setProgram(this.createRoot(this.random, maxdepth, fill));
            program.setRating(-1);
        }
    }

    public IAICommand generate(int maxdepth, boolean fill) {
        if (this.random == null) {
            this.random = new Random();
        }
        this.createTerminalCommandList();
        this.createNodeCommandList();
        return this.createRoot(this.random, maxdepth, fill);
    }

    private void createTerminalCommandList() {
        this.terminalCommands = new ArrayList<IAICommand>();
        int i = 0;
        while (i < this.commandList.size()) {
            if (((AICommand)this.commandList.get(i)).getParameterCount() == 0) {
                this.terminalCommands.add(this.commandList.get(i));
            }
            ++i;
        }
    }

    private void createNodeCommandList() {
        this.nodeCommands = new ArrayList<IAICommand>();
        int i = 0;
        while (i < this.commandList.size()) {
            if (((AICommand)this.commandList.get(i)).getParameterCount() > 0) {
                this.nodeCommands.add(this.commandList.get(i));
            }
            ++i;
        }
    }

    private IAICommand createRoot(Random r, int missingDepth, boolean fill) {
        int pos;
        IAICommand ret = null;
        if (missingDepth == 0) {
            pos = r.nextInt(this.terminalCommands.size());
            ret = ((AICommand)this.terminalCommands.get(pos)).copyRandom();
        } else if (fill) {
            pos = r.nextInt(this.nodeCommands.size());
            ret = ((AICommand)this.nodeCommands.get(pos)).copyRandom();
        } else {
            pos = r.nextInt(this.commandList.size());
            ret = ((AICommand)this.commandList.get(pos)).copyRandom();
        }
        ((AICommand)ret).setRandomValue(r);
        int i = 0;
        while (i < ((AICommand)ret).getParameterCount()) {
            ((AICommand)ret).addParameter(this.createRoot(r, missingDepth - 1, fill));
            ++i;
        }
        return ret;
    }
}

