/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import commands.AICommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import mainClasses.GAProgram;

public class GASaveGraphViz {
    public void save(String filename, GAProgram program) {
        File file = new File(filename);
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write("digraph cmd {\r\n".getBytes());
            this.saveCmd(out, (AICommand)program.getProgram(), 0, AICommand.IsExecutedType.ALWAYS);
            out.write("}\n".getBytes());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int saveCmd(FileOutputStream out, AICommand cmd, int ID, AICommand.IsExecutedType isExecuted) throws IOException {
        int OrgID = ID;
        boolean shortenNotExecuted = AICommand.IsExecutedType.NEVER == isExecuted;
        boolean shortenIsRealConstant = cmd.isConstant() && !cmd.hasSideEffects(true) && cmd.getProgramDepth() > 1;
        out.write(("  cmd_" + OrgID + " [").getBytes());
        String labelNode = "label=\"" + cmd.getShortName();
        if (shortenNotExecuted || shortenIsRealConstant) {
            labelNode = String.valueOf(labelNode) + "\\n" + cmd.getProgramDepth();
        }
        labelNode = String.valueOf(labelNode) + "\"";
        out.write(labelNode.getBytes());
        if (shortenNotExecuted) {
            out.write(",shape=box".getBytes());
        } else if (shortenIsRealConstant) {
            out.write(",shape=hexagon".getBytes());
        }
        out.write(")];\r\n".getBytes());
        if (!shortenNotExecuted && !shortenIsRealConstant) {
            int i = 0;
            while (i < cmd.getCurrentParameterCount()) {
                out.write(("  cmd_" + OrgID + " -> cmd_" + (ID + 1)).getBytes());
                String edge = "";
                if (((AICommand)cmd.getParameter(i)).isConstant()) {
                    edge = String.valueOf(edge) + "label=\"" + cmd.getParameter(i).doCommand(false) + "\"";
                }
                switch (cmd.isParameterExecuted(i)) {
                    case MAYBE: {
                        break;
                    }
                    case ALWAYS: {
                        edge = String.valueOf(edge) + (edge.isEmpty() ? "" : ",") + "style=bold";
                        break;
                    }
                    case NEVER: {
                        edge = String.valueOf(edge) + (edge.isEmpty() ? "" : ",") + "style=dotted";
                    }
                }
                if (!edge.isEmpty()) {
                    out.write((" [" + edge + "]").getBytes());
                }
                out.write(";\r\n".getBytes());
                ID = this.saveCmd(out, (AICommand)cmd.getParameter(i), ID + 1, cmd.isParameterExecuted(i));
                ++i;
            }
        }
        return ID + 1;
    }
}

