/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import commands.AICommand;
import commands.IAICommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mainClasses.GAPopulation;
import mainClasses.GAProgram;

public class GAStatistic {
    private GAPopulation population = null;
    private static int notValidMax = 2000000000;
    private static int notValidMin = -1;
    private boolean firstRunDone = false;
    private boolean secondRunDone = false;
    private boolean medianRunDone = false;
    private int ratedProgramCount = notValidMin;
    private int runningProgramCount = notValidMin;
    private int maxPoints = notValidMin;
    private int minPoints = notValidMax;
    private double averagePoints = notValidMin;
    private double standardDeviationPoints = notValidMin;
    private int maxProgramDepth = notValidMax;
    private int minProgramDepth = notValidMin;
    private List<Integer> medianArray = null;
    private List<PointRangeItem> prArray = null;

    public GAStatistic(GAPopulation population) {
        this.setPopulation(population);
    }

    public void setPopulation(GAPopulation population) {
        this.population = population;
        this.firstRunDone = false;
        this.secondRunDone = false;
        this.medianRunDone = false;
    }

    public int getGeneration() {
        if (this.population != null) {
            return this.population.getGeneration() + 1;
        }
        return notValidMin;
    }

    public int getPopulationSize() {
        if (this.population != null) {
            return this.population.getSize();
        }
        return notValidMin;
    }

    public int getRatedProgramCount() {
        this.firstRun();
        return this.ratedProgramCount;
    }

    public int getRunningProgramCount() {
        this.firstRun();
        return this.runningProgramCount;
    }

    public int getMaxPoints() {
        this.firstRun();
        return this.maxPoints;
    }

    public int getMinPoints() {
        this.firstRun();
        return this.minPoints;
    }

    public int getMaxRating() {
        return this.population.getMaxRating();
    }

    public double getAveragePoints() {
        this.firstRun();
        return this.averagePoints;
    }

    public double getStandardDeviation() {
        this.secondRun();
        return this.standardDeviationPoints;
    }

    public double getPercentDone() {
        this.firstRun();
        if (this.population.getSize() > 0) {
            return (double)this.ratedProgramCount / (double)this.population.getSize();
        }
        return notValidMin;
    }

    public int getCurrentStartedProgramCount() {
        this.firstRun();
        return this.runningProgramCount;
    }

    public int getMinProgramDepth() {
        this.firstRun();
        return this.minProgramDepth;
    }

    public int getMaxProgramDepth() {
        this.firstRun();
        return this.maxProgramDepth;
    }

    public int getMedian(int pos) {
        this.medianRun();
        int mid = this.medianArray.size() / 2;
        int ret = notValidMin;
        if (mid >= this.medianArray.size()) {
            return -1;
        }
        ret = this.medianArray.size() % 2 == 0 ? (pos >= 0 ? this.medianArray.get(mid + pos).intValue() : this.medianArray.get(mid + 1 + pos).intValue()) : (pos >= 0 ? this.medianArray.get(mid + pos).intValue() : this.medianArray.get(mid + 2 + pos).intValue());
        return ret;
    }

    public int getMedian() {
        return (this.getMedian(1) + this.getMedian(-1)) / 2;
    }

    public int getMedian(float procent) {
        this.medianRun();
        int pos = (int)(procent * (float)this.medianArray.size());
        if (pos >= 0 && pos < this.medianArray.size()) {
            return this.medianArray.get(pos);
        }
        return notValidMin;
    }

    public int getAverage(float from, float to) {
        int posFrom = (int)(from * (float)this.medianArray.size());
        int posTo = (int)(to * (float)this.medianArray.size());
        if (posFrom < 0) {
            posFrom = 0;
        }
        if (posTo >= this.medianArray.size()) {
            posTo = this.medianArray.size() - 1;
        }
        if (posFrom >= 0 && posTo >= 0) {
            if (posFrom < this.medianArray.size() && posTo < this.medianArray.size()) {
                if (posFrom <= posTo) {
                    int sum = 0;
                    int i = posFrom;
                    while (i < posTo) {
                        sum += this.medianArray.get(i).intValue();
                        ++i;
                    }
                    return sum / (posTo - posFrom + 1);
                }
                return notValidMin;
            }
            return notValidMin;
        }
        return notValidMin;
    }

    public int getPointRangeCount() {
        return this.prArray.size();
    }

    public PointRangeItem getPointRangeItem(int i) {
        return this.prArray.get(i);
    }

    public int getSinglePointSum() {
        int sum = 0;
        int i = 0;
        while (i < this.prArray.size()) {
            sum += this.prArray.get((int)i).sum;
            ++i;
        }
        return sum;
    }

    private void firstRun() {
        if (!this.firstRunDone) {
            this.ratedProgramCount = 0;
            this.runningProgramCount = 0;
            this.maxPoints = notValidMin;
            this.minPoints = notValidMax;
            this.averagePoints = notValidMin;
            this.minProgramDepth = notValidMax;
            this.maxProgramDepth = notValidMin;
            this.medianArray = new ArrayList<Integer>();
            this.prArray = new ArrayList<PointRangeItem>();
            int sumPoints = 0;
            int i = 0;
            while (i < this.population.getSize()) {
                GAPopulation pop;
                GAProgram prog;
                IAICommand com;
                int currRating = this.population.get(i).getRating();
                boolean foundSItem = false;
                if (currRating > notValidMin) {
                    ++this.ratedProgramCount;
                    sumPoints += currRating;
                    if (this.maxPoints < currRating) {
                        this.maxPoints = currRating;
                    }
                    if (this.minPoints > currRating) {
                        this.minPoints = currRating;
                    }
                    this.medianArray.add(new Integer(currRating));
                    int j = 0;
                    while (j < this.prArray.size()) {
                        if (this.prArray.get((int)j).start <= currRating && this.prArray.get((int)j).end >= currRating) {
                            ++this.prArray.get((int)j).count;
                            this.prArray.get((int)j).sum += currRating;
                            foundSItem = true;
                            break;
                        }
                        ++j;
                    }
                    if (!foundSItem) {
                        PointRangeItem newItem = new PointRangeItem();
                        int start = currRating / 200;
                        newItem.start = start * 200;
                        newItem.end = newItem.start + 199;
                        newItem.count = 1;
                        newItem.sum = currRating;
                        this.prArray.add(newItem);
                    }
                }
                if (this.population.get(i).isStarted()) {
                    ++this.runningProgramCount;
                }
                if ((com = (prog = (pop = this.population).get(i)).getProgram()) != null) {
                    int cur_depth = ((AICommand)com).getProgramDepth();
                    if (this.minProgramDepth > cur_depth) {
                        this.minProgramDepth = cur_depth;
                    }
                    if (this.maxProgramDepth < cur_depth) {
                        this.maxProgramDepth = cur_depth;
                    }
                }
                ++i;
            }
            this.averagePoints = (double)sumPoints / (double)this.ratedProgramCount;
            Collections.sort(this.prArray, new PointRangeComparator());
        }
        this.firstRunDone = true;
    }

    private void secondRun() {
        this.firstRun();
        if (!this.secondRunDone) {
            this.standardDeviationPoints = notValidMin;
            if (this.ratedProgramCount > 1) {
                double sum_deviation = 0.0;
                int i = 0;
                while (i < this.population.getSize()) {
                    int currRating = this.population.get(i).getRating();
                    if (currRating > -1) {
                        double tmp = (double)currRating - this.averagePoints;
                        sum_deviation += tmp * tmp;
                    }
                    ++i;
                }
                this.standardDeviationPoints = Math.sqrt(sum_deviation / (double)(this.ratedProgramCount - 1));
            }
        }
        this.secondRunDone = true;
    }

    public void medianRun() {
        this.firstRun();
        if (!this.medianRunDone) {
            Collections.sort(this.medianArray);
        }
        this.medianRunDone = true;
    }

    public String getVText(int value, String unit, int notValid, String notValidText) {
        if (value != notValid) {
            return String.valueOf(value) + unit;
        }
        return notValidText;
    }

    public String getVText(double value, String unit, int notValid, String notValidText) {
        if (value != (double)notValid) {
            return String.valueOf(value) + unit;
        }
        return notValidText;
    }

    public String getText(String desc, int value, String unit, int notValid, String notValidText) {
        return String.valueOf(desc) + " = " + this.getVText(value, unit, notValid, notValidText) + "\n";
    }

    public class PointRangeComparator
    implements Comparator<PointRangeItem> {
        @Override
        public int compare(PointRangeItem arg0, PointRangeItem arg1) {
            if (arg0.start < arg1.start) {
                return -1;
            }
            if (arg0.start > arg1.start) {
                return 1;
            }
            return 0;
        }
    }

    public class PointRangeItem {
        public int start = 0;
        public int end = 0;
        public int count = 0;
        public int sum = 0;
    }
}

