/*
 * Decompiled with CFR 0.152.
 */
package mainClasses;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mainClasses.ExecutionManager;
import mainClasses.GAProgram;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServerController
extends Thread {
    private String servername = "";
    private int serverport = 0;
    private boolean shutdown = false;
    private ExecutionManager manager = null;
    private String serverStatus = "";
    private OutputStream out = null;
    private Status status = Status.DOWN;
    private final int waitingTimeBetweenStatusCall = 10000;
    private GAProgram program = null;
    private int showNoProgramInfo = 0;
    private boolean currentConfigurating = false;
    private boolean showSendInitializeMessage = true;

    public String setServername(String newServerName) {
        this.servername = newServerName;
        this.setName("ServerController: " + this.servername + ":" + this.serverport);
        return this.servername;
    }

    public int setServerPort(int newPort) {
        this.serverport = newPort;
        this.setName("ServerController: " + this.servername + ":" + this.serverport);
        return this.serverport;
    }

    public ExecutionManager setExecutionManager(ExecutionManager manager) {
        this.manager = manager;
        return this.manager;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void input(String input) {
        if (this.program != null) {
            Date d = new Date();
            this.program.setTimeout(d.getTime() + 180000L);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(input)));
            this.interpret(document);
        }
        catch (ParserConfigurationException e) {
            System.out.println("ServerController.input(): ERROR: " + e.getMessage());
        }
        catch (SAXException e) {
            System.out.println("ServerController.input(): ERROR: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("ServerController.input(): ERROR: " + e.getMessage());
        }
    }

    private void interpret(Document document) {
        Node rootNode = document.getFirstChild();
        String rootString = rootNode.getNodeName();
        if (rootString.equals("status")) {
            String toAdd;
            this.serverStatus = ((Element)rootNode).getAttribute("text");
            Node subNode = rootNode.getFirstChild();
            int rating = -1;
            String identifier = "";
            while (subNode != null) {
                if (subNode.getNodeName().equals("rating")) {
                    rating = Integer.valueOf(subNode.getTextContent());
                    identifier = ((Element)subNode).getAttribute("identifier");
                }
                subNode = subNode.getNextSibling();
            }
            if (this.serverStatus.equals("FINISHED") && !this.currentConfigurating && this.showSendInitializeMessage) {
                this.showSendInitializeMessage = false;
                Date d = new Date();
                DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
                System.out.println(String.valueOf(df.format(d)) + " ServerController.interpret(" + this.servername + ":" + this.serverport + ")");
                this.manager.setRatingFinished(identifier, rating);
            }
            if (!(this.status != Status.AUTOMATIC && this.status != Status.STARTONE || this.currentConfigurating)) {
                this.currentConfigurating = true;
                try {
                    if (this.serverStatus.equals("JUSTBEGIN")) {
                        this.sendCreate();
                    } else if (this.serverStatus.equals("CREATED")) {
                        this.sendInitialize();
                    } else if (this.serverStatus.equals("INITIALIZED")) {
                        this.sendStart();
                        if (this.status == Status.STARTONE) {
                            this.status = Status.MANUAL;
                        }
                    } else if (this.serverStatus.equals("FINISHED")) {
                        this.sendCreate();
                    }
                }
                catch (Exception e) {
                    this.currentConfigurating = false;
                }
                this.currentConfigurating = false;
                this.showSendInitializeMessage = true;
            }
            if (!(toAdd = document.getFirstChild().getTextContent()).isEmpty()) {
                this.serverStatus = String.valueOf(this.serverStatus) + " -> " + toAdd;
            }
        }
    }

    public String getServerName() {
        return this.servername;
    }

    public int getServerPort() {
        return this.serverport;
    }

    public void sendShutdown() {
        this.sendCmd("<shutdown manager=\"" + this.manager.getIdentifier() + "\"/>");
    }

    public void sendCreate() {
        this.sendCmd("<create manager=\"" + this.manager.getIdentifier() + "\"/>");
    }

    public void sendInitialize() {
        Date d = new Date();
        DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
        if (this.manager == null) {
            System.out.println(String.valueOf(df.format(d)) + " ServerController.sendInitialize(): ERROR: No Manager");
            return;
        }
        System.out.println(String.valueOf(df.format(d)) + " ServerController.sendInitialize(" + this.servername + ":" + this.serverport + "): ");
        this.program = this.manager.getNextProgram(this.program);
        if (this.program == null) {
            if (this.showNoProgramInfo == 0) {
                System.out.println(String.valueOf(df.format(d)) + " ServerController.sendInitialize(): ERROR: No Program");
            }
            this.showNoProgramInfo = (this.showNoProgramInfo + 1) % 100000;
            return;
        }
        this.showNoProgramInfo = 0;
        String ret = this.program.getProgramString();
        this.sendCmd("<initialise manager=\"" + this.manager.getIdentifier() + "\" identifier=\"" + this.program.getIdentifier() + "\"><code>" + ret + "</code></initialise>");
    }

    public void sendStart() {
        this.sendCmd("<start manager=\"" + this.manager.getIdentifier() + "\"/>");
    }

    public void sendStop() {
        this.sendCmd("<stop manager=\"" + this.manager.getIdentifier() + "\"/>");
    }

    public void sendStatus() {
        this.sendCmd("<status manager=\"" + this.manager.getIdentifier() + "\"/>");
    }

    public void sendSetting(String servername) {
        this.sendCmd("<setting manager=\"" + this.manager.getIdentifier() + "\" servername=\"" + servername + "\"/>");
    }

    public void sendCmd(String send) {
        if (this.out != null) {
            try {
                this.out.write((String.valueOf(send) + "<!--ende-->").getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getServerStatus() {
        return this.serverStatus;
    }

    public void doShutdown() {
        this.shutdown = true;
    }

    public void activateAutomaticMode() {
        this.status = Status.AUTOMATIC;
    }

    public void activateManualMode() {
        this.status = Status.MANUAL;
    }

    public Status getStatus() {
        return this.status;
    }

    public void activateStartOneMode() {
        this.status = Status.STARTONE;
    }

    private class Listener
    extends Thread {
        private ServerController ctrl = null;
        private Socket socket = null;
        private boolean shutdown = false;

        public Listener(ServerController controller, Socket socket) {
            this.ctrl = controller;
            this.socket = socket;
            this.setName("ServerController.Listener: " + ServerController.this.servername + ":" + ServerController.this.serverport);
        }

        @Override
        public void run() {
            InputStream in = null;
            try {
                in = this.socket.getInputStream();
            }
            catch (IOException e) {
                return;
            }
            String input = "";
            while (!this.shutdown) {
                try {
                    input = String.valueOf(input) + (char)in.read();
                }
                catch (IOException e) {
                    break;
                }
                if (input.indexOf("<!--ende-->") <= -1) continue;
                this.ctrl.input(input);
                input = "";
            }
        }

        static /* synthetic */ void access$0(Listener listener, boolean bl) {
            listener.shutdown = bl;
        }
    }

    public static enum Status {
        DOWN,
        AUTOMATIC,
        MANUAL,
        STARTONE;

    }
}

