/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public abstract class SimpleStyledCellLabelProvider
extends OwnerDrawLabelProvider {
    private static final String KEY_TEXT_LAYOUT = "styled_label_key_";
    public static final int COLORS_ON_SELECTION = 1;
    public static final int NO_FOCUS = 2;
    private static final int OWNER_DRAW_ENABLED = 16;
    private int style;
    private TextLayout cachedTextLayout;
    private LabelPresentationInfo cachedLabelInfo;
    private boolean cachedWasWithColors;
    private ColumnViewer viewer;
    private ViewerColumn column;

    public SimpleStyledCellLabelProvider() {
        this(0);
    }

    public SimpleStyledCellLabelProvider(int style) {
        this.style = style & 3 | 0x10;
    }

    public boolean isOwnerDrawEnabled() {
        return (this.style & 0x10) != 0;
    }

    public void setOwnerDrawEnabled(boolean enabled) {
        boolean isEnabled = this.isOwnerDrawEnabled();
        if (isEnabled != enabled) {
            this.style = enabled ? (this.style |= 0x10) : (this.style &= 0xFFFFFFEF);
            if (this.viewer != null) {
                this.setOwnerDrawEnabled(this.viewer, this.column, enabled);
            }
        }
    }

    protected final ColumnViewer getViewer() {
        return this.viewer;
    }

    protected final ViewerColumn getColumn() {
        return this.column;
    }

    protected abstract LabelPresentationInfo getLabelPresentationInfo(Object var1);

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        Assert.isTrue((this.viewer == null && this.column == null ? 1 : 0) != 0, (String)"Label provider instance already in use");
        this.viewer = viewer;
        this.column = column;
        super.initialize(viewer, column, this.isOwnerDrawEnabled());
    }

    public void dispose() {
        if (this.cachedTextLayout != null) {
            this.cachedTextLayout.dispose();
            this.cachedTextLayout = null;
        }
        this.cachedLabelInfo = null;
        this.viewer = null;
        this.column = null;
        super.dispose();
    }

    public void update(ViewerCell cell) {
        LabelPresentationInfo info = this.getLabelPresentationInfo(cell.getElement());
        cell.setImage(info.getImage());
        cell.setText(info.getText());
        cell.setFont(info.getDefaultFont());
        cell.setBackground(info.getDefaultBackground());
        cell.setForeground(info.getDefaultForeground());
        if (this.isOwnerDrawEnabled()) {
            cell.getItem().setData(KEY_TEXT_LAYOUT + cell.getColumnIndex(), info);
        } else {
            cell.getItem().setData(KEY_TEXT_LAYOUT + cell.getColumnIndex(), null);
        }
        super.update(cell);
    }

    private TextLayout getSharedTextLayout(Display display) {
        if (this.cachedTextLayout == null) {
            this.cachedTextLayout = new TextLayout(display);
            this.cachedTextLayout.setOrientation(Window.getDefaultOrientation());
        }
        return this.cachedTextLayout;
    }

    private boolean useColors(Event event) {
        return (event.detail & 2) == 0 || (this.style & 1) != 0;
    }

    private boolean drawFocus(Event event) {
        return (event.detail & 4) != 0 && (this.style & 2) == 0;
    }

    private LabelPresentationInfo getInfo(Event event) {
        return (LabelPresentationInfo)event.item.getData(KEY_TEXT_LAYOUT + event.index);
    }

    private TextLayout getTextLayoutForInfo(Display display, LabelPresentationInfo labelPresentation, boolean applyColors, Item item, int index) {
        if (this.cachedLabelInfo == labelPresentation && applyColors == this.cachedWasWithColors) {
            return this.cachedTextLayout;
        }
        TextLayout sharedLayout = this.getSharedTextLayout(display);
        this.applyInfoToLayout(sharedLayout, labelPresentation, applyColors, item, index);
        this.cachedLabelInfo = labelPresentation;
        this.cachedWasWithColors = applyColors;
        return sharedLayout;
    }

    private void applyInfoToLayout(TextLayout layout, LabelPresentationInfo labelInfo, boolean applyColors, Item item, int index) {
        layout.setText("");
        layout.setText(labelInfo.getText());
        Font font = labelInfo.getDefaultFont();
        if (font == null) {
            if (item instanceof TableItem) {
                font = ((TableItem)item).getFont(index);
            } else if (item instanceof TreeItem) {
                font = ((TreeItem)item).getFont(index);
            }
        }
        layout.setFont(font);
        StyleRange[] styleRanges = labelInfo.getStyleRanges();
        int i = 0;
        while (i < styleRanges.length) {
            StyleRange curr = styleRanges[i];
            if (curr.font != null || !applyColors && (curr.foreground != null || curr.background != null)) {
                curr = (StyleRange)curr.clone();
                curr.font = null;
                if (!applyColors) {
                    curr.foreground = null;
                    curr.background = null;
                }
            }
            layout.setStyle(curr, curr.start, curr.start + curr.length - 1);
            ++i;
        }
    }

    protected void erase(Event event, Object element) {
        LabelPresentationInfo labelInfo = this.getInfo(event);
        if (labelInfo != null) {
            event.detail &= 0xFFFFFFEF;
        }
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        Image image;
        LabelPresentationInfo labelInfo = this.getInfo(event);
        if (labelInfo == null) {
            return;
        }
        boolean applyColors = this.useColors(event);
        GC gc = event.gc;
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        if (applyColors) {
            Color background;
            Color foreground = labelInfo.getDefaultForeground();
            if (foreground != null) {
                gc.setForeground(foreground);
            }
            if ((background = labelInfo.getDefaultBackground()) != null) {
                gc.setBackground(background);
            }
        }
        if ((image = labelInfo.getImage()) != null) {
            Rectangle imageBounds = this.getImageBounds(event);
            Rectangle bounds = image.getBounds();
            int x = imageBounds.x + Math.max(0, (imageBounds.width - bounds.width) / 2);
            int y = imageBounds.y + Math.max(0, (imageBounds.height - bounds.height) / 2);
            gc.drawImage(image, x, y);
        }
        TextLayout textLayout = this.getTextLayoutForInfo(event.display, labelInfo, applyColors, (Item)event.item, event.index);
        Rectangle layoutBounds = textLayout.getBounds();
        Rectangle textBounds = this.getTextBounds(event);
        int x = textBounds.x;
        int y = textBounds.y + Math.max(0, (textBounds.height - layoutBounds.height) / 2);
        textLayout.draw(gc, x, y);
        if (this.drawFocus(event)) {
            Rectangle focusBounds = this.getBounds(event);
            gc.drawFocus(focusBounds.x, focusBounds.y, focusBounds.width, focusBounds.height);
        }
        gc.setForeground(oldForeground);
        gc.setBackground(oldBackground);
    }

    private Rectangle getBounds(Event event) {
        Item item = (Item)event.item;
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds();
        }
        return null;
    }

    private Rectangle getImageBounds(Event event) {
        Item item = (Item)event.item;
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getImageBounds(event.index);
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getImageBounds(event.index);
        }
        return null;
    }

    private Rectangle getTextBounds(Event event) {
        Item item = (Item)event.item;
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getTextBounds(event.index);
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getTextBounds(event.index);
        }
        return null;
    }

    public static class LabelPresentationInfo {
        private final String text;
        private final Image image;
        private final StyleRange[] ranges;
        private final Font defaultFont;
        private final Color defaultForegroundColor;
        private final Color defaultBackgroundColor;

        public LabelPresentationInfo(String text, StyleRange[] ranges, Image image, Font defaultFont, Color defaultForegroundColor, Color defaultBackgroundColor) {
            Assert.isNotNull((Object)text);
            Assert.isNotNull((Object)ranges);
            this.text = text;
            this.ranges = ranges;
            this.image = image;
            this.defaultFont = defaultFont;
            this.defaultForegroundColor = defaultForegroundColor;
            this.defaultBackgroundColor = defaultBackgroundColor;
        }

        public String getText() {
            return this.text;
        }

        public StyleRange[] getStyleRanges() {
            return this.ranges;
        }

        public Image getImage() {
            return this.image;
        }

        public Color getDefaultBackground() {
            return this.defaultBackgroundColor;
        }

        public Font getDefaultFont() {
            return this.defaultFont;
        }

        public Color getDefaultForeground() {
            return this.defaultForegroundColor;
        }
    }
}

