/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.CHOOSECOLOR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    Display display;
    int width;
    int height;
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 32768);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    int CCHookProc(int hdlg, int uiMsg, int lParam, int lpData) {
        switch (uiMsg) {
            case 272: {
                RECT rect = new RECT();
                OS.GetWindowRect(hdlg, rect);
                this.width = rect.right - rect.left;
                this.height = rect.bottom - rect.top;
                if (this.title == null || this.title.length() == 0) break;
                TCHAR buffer = new TCHAR(0, this.title, true);
                OS.SetWindowText(hdlg, buffer);
                break;
            }
            case 2: {
                RECT rect = new RECT();
                OS.GetWindowRect(hdlg, rect);
                int newWidth = rect.right - rect.left;
                int newHeight = rect.bottom - rect.top;
                if (newWidth >= this.width && newHeight >= this.height && newWidth > this.width) break;
            }
        }
        return 0;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int hwndOwner = this.parent.handle;
        Callback callback = new Callback(this, "CCHookProc", 4);
        int lpfnHook = callback.getAddress();
        if (lpfnHook == 0) {
            SWT.error(3);
        }
        this.display = this.parent.display;
        if (this.display.lpCustColors == 0) {
            int hHeap = OS.GetProcessHeap();
            this.display.lpCustColors = OS.HeapAlloc(hHeap, 8, 64);
        }
        CHOOSECOLOR lpcc = new CHOOSECOLOR();
        lpcc.lStructSize = CHOOSECOLOR.sizeof;
        lpcc.Flags = 272;
        lpcc.lpfnHook = lpfnHook;
        lpcc.hwndOwner = hwndOwner;
        lpcc.lpCustColors = this.display.lpCustColors;
        if (this.rgb != null) {
            lpcc.Flags |= 1;
            int red = this.rgb.red & 0xFF;
            int green = this.rgb.green << 8 & 0xFF00;
            int blue = this.rgb.blue << 16 & 0xFF0000;
            lpcc.rgbResult = red | green | blue;
        }
        Dialog oldModal = null;
        if ((this.style & 0x30000) != 0) {
            oldModal = this.display.getModalDialog();
            this.display.setModalDialog(this);
        }
        boolean success = OS.ChooseColor(lpcc);
        if ((this.style & 0x30000) != 0) {
            this.display.setModalDialog(oldModal);
        }
        if (success) {
            int red = lpcc.rgbResult & 0xFF;
            int green = lpcc.rgbResult >> 8 & 0xFF;
            int blue = lpcc.rgbResult >> 16 & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        callback.dispose();
        this.display = null;
        if (!success) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

