/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import simulation.SocketCommunication;

public class PeerToPeerConnection
extends Thread {
    private Socket client = null;
    private InputStream in = null;
    private OutputStream out = null;
    private SocketCommunication server = null;
    private boolean shutdown = false;

    public PeerToPeerConnection(Socket newClient, SocketCommunication server) {
        this.setName("PeerToPeerConnection");
        this.client = newClient;
        this.server = server;
        try {
            this.in = this.client.getInputStream();
            this.out = this.client.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void send(String toSendText) {
        try {
            this.out.write(toSendText.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        String input = "";
        int tries = 0;
        while (!this.shutdown) {
            try {
                input = String.valueOf(input) + (char)this.in.read();
                tries = 0;
            }
            catch (IOException e) {
                if (++tries > 3) break;
                try {
                    PeerToPeerConnection.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (input.indexOf("<!--ende-->") <= -1) continue;
            this.server.input(input);
            input = "";
        }
        this.close();
    }

    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
                this.server.removeClient(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.client = null;
        }
    }

    public void doShutdown() {
        this.shutdown = true;
        this.close();
    }
}

