/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import commands.KeyCommand;
import extern.FramePacket;
import extern.KeysPacket;
import extern.ServerConnection;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import simulation.ICommunicationToSimulation;

public class SimulationCommunicator
implements ICommunicationToSimulation {
    public ServerConnection serverConnection = null;
    private KeysPacket keysPacket = new KeysPacket();
    private Semaphore sendKeySemaphore = new Semaphore(1);

    @Override
    public void sendGameKeys(int key, KeyCommand.Type type) {
        this.sendKey(key %= 5, type);
    }

    @Override
    public void sendKey(int key, KeyCommand.Type type) {
        try {
            this.sendKeySemaphore.acquire();
        }
        catch (InterruptedException e1) {
            return;
        }
        switch (key %= 6) {
            case 0: {
                this.keysPacket.left(type == KeyCommand.Type.PRESS);
                break;
            }
            case 1: {
                this.keysPacket.right(type == KeyCommand.Type.PRESS);
                break;
            }
            case 2: {
                this.keysPacket.thrust(type == KeyCommand.Type.PRESS);
                break;
            }
            case 3: {
                this.keysPacket.fire(type == KeyCommand.Type.PRESS);
                break;
            }
            case 4: {
                this.keysPacket.hyperspace(type == KeyCommand.Type.PRESS);
                break;
            }
            case 5: {
                this.keysPacket.start(type == KeyCommand.Type.PRESS);
            }
        }
        try {
            if (this.serverConnection != null) {
                this.serverConnection.send(this.keysPacket);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sendKeySemaphore.release();
    }

    @Override
    public void resetKeys() {
        try {
            this.sendKeySemaphore.acquire();
        }
        catch (InterruptedException e1) {
            return;
        }
        this.keysPacket.reset();
        try {
            if (this.serverConnection != null) {
                this.serverConnection.send(this.keysPacket);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sendKeySemaphore.release();
    }

    @Override
    public void getFrame(FramePacket framePacket) {
        if (this.serverConnection != null) {
            try {
                this.serverConnection.receive(framePacket);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        if (this.serverConnection != null) {
            this.serverConnection.stop();
        }
    }

    @Override
    public void setServername(String servername) {
        this.serverConnection.setServername(servername);
    }
}

