/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import commands.AICommand;
import commands.IAICommand;
import global.CreateProgramTree;
import global.Logger;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mainClasses.GALibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import simulation.ICommunication;
import simulation.ICommunicationToSimulation;
import simulation.SimulationDisplay;
import simulation.SimulationExecutor;

public class SimulationController
extends Thread {
    private SimulationExecutor executor = null;
    private ICommunication communicator = null;
    private ICommunicationToSimulation communicator2Simulation = null;
    private Logger logger = null;
    private CreateProgramTree creater = null;
    private SimulationDisplay display = null;
    private Thread displayThread = null;
    private boolean shutdown = false;
    private Status status = Status.UNKNOWN;
    private String currentManagerIdentifier = "";
    private String currentProgramIdentifier = "";
    private GALibrary library = null;

    public SimulationController() {
        this.setName("SimulationController");
    }

    public void setCommunicator(ICommunication iCommunicator) {
        this.communicator = iCommunicator;
    }

    public void setCommunicationToSimulation(ICommunicationToSimulation iCommunicatorToSimulation) {
        this.communicator2Simulation = iCommunicatorToSimulation;
        if (this.executor != null) {
            this.executor.setCommunicator(this.communicator2Simulation);
        }
    }

    public void setLogger(Logger newLogger) {
        this.logger = newLogger;
    }

    public void setCreater(CreateProgramTree newCreater) {
        this.creater = newCreater;
    }

    public void setDisplay(SimulationDisplay newDisplay) {
        this.display = newDisplay;
        this.displayThread = new Thread(this.display);
        this.displayThread.setName("SimulationDisplay");
        if (this.executor != null) {
            this.executor.setDisplay(this.display);
        }
    }

    public void setLibrary(GALibrary library) {
        this.library = library;
    }

    public void doShutdown() {
        this.doShutdown(null);
    }

    public void doShutdown(Node node) {
        this.shutdown = true;
        if (this.display != null) {
            this.display.doShutdown();
        }
        if (this.executor != null) {
            this.executor.shutdown = true;
            this.executor.interrupt();
        }
        if (this.communicator != null) {
            this.communicator.doShutdown();
        }
        this.interrupt();
    }

    public void doCreate(Node node) {
        if (this.executor == null || this.status == Status.FINISHED) {
            try {
                String m;
                this.currentManagerIdentifier = m = ((Element)node).getAttribute("manager").trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.executor = new SimulationExecutor();
            this.executor.setCommunicator(this.communicator2Simulation);
            this.executor.setDisplay(this.display);
            this.executor.setLogger(this.logger);
            this.status = Status.CREATED;
        }
    }

    public void doInitialise(Node node) {
        String m = "";
        try {
            m = ((Element)node).getAttribute("manager").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.status == Status.CREATED && this.currentManagerIdentifier.equals(m)) {
            boolean correct = false;
            NodeList nList = node.getChildNodes();
            int i = 0;
            while (i < nList.getLength()) {
                Node subNode = nList.item(i);
                if (subNode.getNodeName().equals("code") && this.executor != null) {
                    IAICommand cmd = this.creater.interpret(subNode.getTextContent());
                    this.executor.setCommandTree(cmd);
                    correct = true;
                }
                ++i;
            }
            if (correct) {
                this.currentProgramIdentifier = ((Element)node).getAttribute("identifier");
                this.display.initialise();
                this.status = Status.INITIALIZED;
            }
        }
    }

    public void doStart(Node node) {
        String m = "";
        try {
            m = ((Element)node).getAttribute("manager").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.status == Status.INITIALIZED && this.currentManagerIdentifier.equals(m) && this.executor != null) {
            if (!this.displayThread.isAlive()) {
                this.displayThread.start();
            }
            if (!this.executor.isAlive()) {
                this.executor.start();
            }
            this.status = Status.STARTED;
        }
    }

    public void doStop(Node node) {
        String m = "";
        try {
            m = ((Element)node).getAttribute("manager").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.status == Status.STARTED && this.currentManagerIdentifier.equals(m) && this.executor != null) {
            this.executor.shutdown = true;
            this.executor.interrupt();
            this.display.doShutdown();
            this.status = Status.STOPPED;
        }
    }

    public void doStatusReport(Node node) {
        String ret = "";
        String val = "";
        switch (this.status) {
            case UNKNOWN: {
                ret = "UNKNOWN";
                break;
            }
            case JUSTBEGIN: {
                ret = "JUSTBEGIN";
                break;
            }
            case CREATED: {
                ret = "CREATED";
                break;
            }
            case INITIALIZED: {
                ret = "INITIALIZED";
                break;
            }
            case STARTED: {
                ret = "STARTED";
                val = "<rating identifier=\"" + this.currentProgramIdentifier + "\">" + this.display.getLastPoints() + "</rating>";
                break;
            }
            case FINISHED: {
                ret = "FINISHED";
                val = "<rating identifier=\"" + this.currentProgramIdentifier + "\">" + this.display.getLastPoints() + "</rating>";
                break;
            }
            case STOPPED: {
                ret = "STOPPED";
            }
        }
        ret = "<status text=\"" + ret + "\">" + val + "</status><!--ende-->";
        this.communicator.sendCommand(ret);
    }

    public void doChangeSetting(Node node) {
        String m = "";
        try {
            m = ((Element)node).getAttribute("manager").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.status == Status.FINISHED || this.currentManagerIdentifier.equals(m)) {
            String servername = ((Element)node).getAttribute("servername");
            this.communicator2Simulation.setServername(servername);
        }
    }

    public void doAddLibraryProgram(Node node) {
        String m = "";
        try {
            m = ((Element)node).getAttribute("manager").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.status == Status.CREATED && this.currentManagerIdentifier.equals(m)) {
            boolean correct = false;
            IAICommand cmd = null;
            NodeList nList = node.getChildNodes();
            int id = 0;
            int i = 0;
            while (i < nList.getLength()) {
                Node subNode = nList.item(i);
                if (subNode.getNodeName().equals("code")) {
                    try {
                        String tmp = ((Element)subNode).getAttribute("id").trim();
                        id = Integer.valueOf(tmp);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cmd = this.creater.interpret(subNode.getTextContent());
                    correct = true;
                }
                ++i;
            }
            if (correct) {
                this.library.setManagerID(m);
                this.library.addProgram(id, (AICommand)cmd);
            }
        }
    }

    public void doClearLibrary(Node node) {
        String m = "";
        try {
            m = ((Element)node).getAttribute("manager").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.status == Status.CREATED && this.currentManagerIdentifier.equals(m)) {
            boolean force = false;
            try {
                force = ((Element)node).getAttribute("force").trim().equalsIgnoreCase("TRUE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (force || this.library.getManagerID().equals(m)) {
                this.library.clear();
            }
        }
    }

    public void interpret(Document document) {
        String root = document.getFirstChild().getNodeName();
        if (!root.equals("status")) {
            Date d = new Date();
            DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
            System.out.println(String.valueOf(df.format(d)) + " SimulationController.interpret(): " + root);
        }
        if (root.equals("shutdown")) {
            this.doShutdown(document.getFirstChild());
        } else if (root.equals("create")) {
            this.doCreate(document.getFirstChild());
        } else if (root.equals("initialise")) {
            this.doInitialise(document.getFirstChild());
        } else if (root.equals("start")) {
            this.doStart(document.getFirstChild());
        } else if (root.equals("stop")) {
            this.doStop(document.getFirstChild());
        } else if (root.equals("status")) {
            this.doStatusReport(document.getFirstChild());
        } else if (root.equals("setting")) {
            this.doChangeSetting(document.getFirstChild());
        } else if (root.equals("library")) {
            this.doAddLibraryProgram(document.getFirstChild());
        } else if (root.equals("clearlibrary")) {
            this.doClearLibrary(document.getFirstChild());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.status = Status.JUSTBEGIN;
        if (this.communicator != null) ** GOTO lbl22
        return;
lbl-1000:
        // 1 sources

        {
            command = this.communicator.getNextCommand();
            this.checkCurrentExecution();
            if (command == null || command.equals("")) continue;
            factory = DocumentBuilderFactory.newInstance();
            builder = null;
            try {
                builder = factory.newDocumentBuilder();
                document = builder.parse(new InputSource(new StringReader(command)));
                this.interpret(document);
                continue;
            }
            catch (ParserConfigurationException e) {
                System.out.println("SimulationController.run(): " + e.getMessage());
                continue;
            }
            catch (SAXException e) {
                System.out.println("SimulationController.run(): " + e.getMessage());
                continue;
            }
            catch (IOException e) {
                System.out.println("SimulationController.run(): " + e.getMessage());
            }
lbl22:
            // 6 sources

            ** while (!this.isInterrupted() && !this.shutdown)
        }
lbl23:
        // 1 sources

        this.status = Status.STOPPED;
    }

    private void checkCurrentExecution() {
        if (this.status == Status.STARTED) {
            if (this.executor != null) {
                if (this.executor.getStatus() == SimulationExecutor.ExecutorStatus.FINISHED) {
                    this.status = Status.FINISHED;
                }
            } else {
                System.out.println("SimulationController.checkCurrentExecution(): ERROR: state is started but no executor");
                this.status = Status.UNKNOWN;
            }
        }
    }

    public static enum Status {
        UNKNOWN,
        JUSTBEGIN,
        CREATED,
        INITIALIZED,
        STARTED,
        FINISHED,
        STOPPED;

    }
}

