/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import extern.Asteroid;
import extern.FramePacket;
import extern.GameStatus;
import extern.Position;
import extern.Saucer;
import extern.Ship;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import simulation.ICommunicationToSimulation;
import simulation.Memory;

public class SimulationDisplay
extends Memory
implements Runnable {
    private FramePacket framePacket = null;
    private GameStatus gameStatus = null;
    private ICommunicationToSimulation communication = null;
    private boolean shutdown = false;

    public SimulationDisplay() {
        this.size = 500;
        this.framePacket = new FramePacket();
        this.gameStatus = new GameStatus();
    }

    public void setCommunication(ICommunicationToSimulation newCommunication) {
        this.communication = newCommunication;
    }

    @Override
    public void initialise() {
        super.initialise();
    }

    @Override
    public int setSize(int newSize) {
        return this.getSize();
    }

    @Override
    public int getSize() {
        return super.getSize();
    }

    @Override
    public int getValue(int pos) {
        int ret;
        block103: {
            block104: {
                block102: {
                    ret = 0;
                    if ((pos %= 300) >= 5) break block102;
                    Ship ship = this.gameStatus.getShip();
                    if (ship != null) {
                        switch (pos) {
                            case 0: {
                                ret = 1000;
                                break;
                            }
                            case 1: {
                                ret = ship.getX() * 1000;
                                break;
                            }
                            case 2: {
                                ret = ship.getY() * 1000;
                                break;
                            }
                            case 3: {
                                ret = ship.getOrientation().getX() * 1000;
                                break;
                            }
                            case 4: {
                                ret = ship.getOrientation().getY() * 1000;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block103;
                }
                if (pos >= 10) break block104;
                switch (pos) {
                    case 5: {
                        ret = this.gameStatus.getShip() == null ? 0 : 1000;
                        break;
                    }
                    case 6: {
                        ret = this.gameStatus.getSaucer() == null ? 0 : 1000;
                        break;
                    }
                    case 7: {
                        ret = this.gameStatus.getShots().size() * 1000;
                        break;
                    }
                    case 8: {
                        ret = this.gameStatus.getAsteroids().size() * 1000;
                        break;
                    }
                    case 9: {
                        Ship ship = this.gameStatus.getShip();
                        if (ship == null) break block103;
                        ret = (int)(Math.atan2(ship.getX(), ship.getY()) * 1000.0);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block103;
            }
            if (pos < 20) {
                Saucer saucer = this.gameStatus.getSaucer();
                if (saucer != null) {
                    switch (pos) {
                        case 10: {
                            ret = 1000;
                            break;
                        }
                        case 11: {
                            ret = saucer.getX() * 1000;
                            break;
                        }
                        case 12: {
                            ret = saucer.getY() * 1000;
                            break;
                        }
                        case 13: {
                            ret = saucer.getSize() == Saucer.Size.SMALL ? 1000 : 2000;
                            break;
                        }
                        case 14: {
                            ret = this.calcMinDistanceShip(saucer.getX(), saucer.getY(), true) * 1000;
                            break;
                        }
                        case 15: {
                            ret = this.calcMinDistanceShip(saucer.getX(), saucer.getY(), false) * 1000;
                            break;
                        }
                        case 16: {
                            ret = (int)(this.calcMinDistanceShip(saucer.getX(), saucer.getY()) * 1000.0);
                            break;
                        }
                        case 17: {
                            ret = (int)(this.calcTanShip(saucer.getX(), saucer.getY()) * 1000.0);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (pos < 30) {
                Position nearest = null;
                double dist = 2.0E7;
                List<Asteroid> aList = this.gameStatus.getAsteroids();
                int index = -1;
                int i = 0;
                while (i < aList.size()) {
                    block101: {
                        try {
                            double d;
                            Asteroid asteroid = aList.get(i);
                            if (asteroid == null || !((d = this.calcMinDistanceShip(asteroid.getX(), asteroid.getY())) < dist)) break block101;
                            dist = d;
                            nearest = asteroid;
                            index = i;
                        }
                        catch (IndexOutOfBoundsException e) {
                            break;
                        }
                    }
                    ++i;
                }
                if (nearest != null) {
                    block27 : switch (pos % 10) {
                        case 0: {
                            ret = 1000;
                            break;
                        }
                        case 1: {
                            ret = nearest.getX() * 1000;
                            break;
                        }
                        case 2: {
                            ret = nearest.getY() * 1000;
                            break;
                        }
                        case 3: {
                            ret = this.calcMinDistanceShip(nearest.getX(), nearest.getY(), true) * 1000;
                            break;
                        }
                        case 4: {
                            ret = this.calcMinDistanceShip(nearest.getX(), nearest.getY(), false) * 1000;
                            break;
                        }
                        case 5: {
                            ret = (int)(this.calcMinDistanceShip(nearest.getX(), nearest.getY()) * 1000.0);
                            break;
                        }
                        case 6: {
                            switch (((Asteroid)nearest).getSize()) {
                                case SMALL: {
                                    ret = 1000;
                                    break block27;
                                }
                                case MIDDLE: {
                                    ret = 2000;
                                    break block27;
                                }
                                case BIG: {
                                    ret = 3000;
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (((Asteroid)nearest).getType()) {
                                case TYPE_1: {
                                    ret = 1000;
                                    break block27;
                                }
                                case TYPE_2: {
                                    ret = 2000;
                                    break block27;
                                }
                                case TYPE_3: {
                                    ret = 3000;
                                    break block27;
                                }
                                case TYPE_4: {
                                    ret = 4000;
                                }
                            }
                            break;
                        }
                        case 8: {
                            ret = (int)(this.calcTanShip(nearest.getX(), nearest.getY()) * 1000.0);
                            break;
                        }
                        case 9: {
                            ret = index * 1000;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                int itemNo = (pos - 30) / 20;
                int sumPos = pos % 10;
                int pos2 = (pos - 30) % 20;
                if (pos2 < 10) {
                    Position shot = null;
                    if (this.gameStatus.getShots().size() > itemNo) {
                        try {
                            shot = this.gameStatus.getShots().get(itemNo);
                        }
                        catch (IndexOutOfBoundsException e) {
                            shot = null;
                        }
                    }
                    if (shot != null) {
                        switch (sumPos) {
                            case 0: {
                                ret = 1000;
                                break;
                            }
                            case 1: {
                                ret = shot.getX() * 1000;
                                break;
                            }
                            case 2: {
                                ret = shot.getY() * 1000;
                                break;
                            }
                            case 3: {
                                ret = this.calcMinDistanceShip(shot.getX(), shot.getY(), true) * 1000;
                                break;
                            }
                            case 4: {
                                ret = this.calcMinDistanceShip(shot.getX(), shot.getY(), false) * 1000;
                                break;
                            }
                            case 5: {
                                ret = (int)(this.calcMinDistanceShip(shot.getX(), shot.getY()) * 1000.0);
                                break;
                            }
                            case 6: {
                                ret = (int)(this.calcTanShip(shot.getX(), shot.getY()) * 1000.0);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else {
                    Position asteroid = null;
                    if (this.gameStatus.getAsteroids().size() > itemNo) {
                        try {
                            asteroid = this.gameStatus.getAsteroids().get(itemNo);
                        }
                        catch (IndexOutOfBoundsException e) {
                            asteroid = null;
                        }
                    }
                    if (asteroid != null) {
                        switch (sumPos) {
                            case 0: {
                                ret = 1000;
                                break;
                            }
                            case 1: {
                                ret = asteroid.getX() * 1000;
                                break;
                            }
                            case 2: {
                                ret = asteroid.getY() * 1000;
                                break;
                            }
                            case 3: {
                                ret = this.calcMinDistanceShip(asteroid.getX(), asteroid.getY(), true) * 1000;
                                break;
                            }
                            case 4: {
                                ret = this.calcMinDistanceShip(asteroid.getX(), asteroid.getY(), false) * 1000;
                                break;
                            }
                            case 5: {
                                ret = (int)(this.calcMinDistanceShip(asteroid.getX(), asteroid.getY()) * 1000.0);
                                break;
                            }
                            case 6: {
                                switch (((Asteroid)asteroid).getSize()) {
                                    case SMALL: {
                                        ret = 1000;
                                        break;
                                    }
                                    case MIDDLE: {
                                        ret = 2000;
                                        break;
                                    }
                                    case BIG: {
                                        ret = 3000;
                                    }
                                }
                                break;
                            }
                            case 7: {
                                switch (((Asteroid)asteroid).getType()) {
                                    case TYPE_1: {
                                        ret = 1000;
                                        break;
                                    }
                                    case TYPE_2: {
                                        ret = 2000;
                                        break;
                                    }
                                    case TYPE_3: {
                                        ret = 3000;
                                        break;
                                    }
                                    case TYPE_4: {
                                        ret = 4000;
                                    }
                                }
                                break;
                            }
                            case 8: {
                                ret = (int)(this.calcTanShip(asteroid.getX(), asteroid.getY()) * 1000.0);
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public int setValue(int pos, int value) {
        return 0;
    }

    @Override
    public void run() {
        this.shutdown = false;
        while (!this.shutdown) {
            if (this.communication != null && this.framePacket != null) {
                this.communication.getFrame(this.framePacket);
            }
            if (this.gameStatus == null || this.framePacket == null) continue;
            this.gameStatus.interpretScreen(this.framePacket, 0);
        }
    }

    public void doShutdown() {
        this.shutdown = true;
        if (this.communication != null) {
            this.communication.stop();
        }
    }

    public boolean checkPlayerShipVisible() {
        return this.gameStatus != null && this.gameStatus.getShip() != null;
    }

    public int getLastPoints() {
        return this.gameStatus.getLastPoints();
    }

    public String getDisplayText() {
        return this.gameStatus.getText();
    }

    public double calcTanShip(int X1, int Y1) {
        Ship ship = this.gameStatus.getShip();
        if (ship != null) {
            double x = this.calcMinDistanceShip(X1, Y1, true);
            double y = this.calcMinDistanceShip(X1, Y1, false);
            return Math.atan2(x, y);
        }
        return 0.0;
    }

    public double calcMinDistanceShip(int X1, int Y1) {
        Ship ship = this.gameStatus.getShip();
        if (ship != null) {
            DistValues[] dists = this.calcMinDistance(X1, Y1, ship.getX(), ship.getY());
            return Math.sqrt(dists[0].distSquare);
        }
        return 2.0E8;
    }

    public int calcMinDistanceShip(int X1, int Y1, boolean wantX) {
        Ship ship = this.gameStatus.getShip();
        if (ship != null) {
            return this.calcMinDistance(X1, Y1, ship.getX(), ship.getY(), wantX);
        }
        return 0;
    }

    public int calcMinDistance(int X1, int Y1, int X2, int Y2, boolean wantX) {
        DistValues[] dists = this.calcMinDistance(X1, Y1, X2, Y2);
        if (wantX) {
            return dists[0].dX;
        }
        return dists[0].dY;
    }

    public DistValues[] calcMinDistance(int X1, int Y1, int X2, int Y2) {
        int maxX = 1024;
        int minY = 128;
        int maxY = 896;
        int X1_ = X1 + 1024;
        int Y1_ = Y1 - 128 + 896;
        int X2_ = X2 + 1024;
        int Y2_ = Y2 - 128 + 896;
        DistValues[] dists = new DistValues[9];
        int i = 0;
        while (i < dists.length) {
            dists[i] = new DistValues();
            ++i;
        }
        dists[0].dX = X1 - X2;
        dists[0].dY = Y1 - Y2;
        dists[1].dX = X1_ - X2;
        dists[1].dY = Y1 - Y2;
        dists[2].dX = X1 - X2;
        dists[2].dY = Y1_ - Y2;
        dists[3].dX = X1_ - X2;
        dists[3].dY = Y1_ - Y2;
        dists[4].dX = X1 - X2_;
        dists[4].dY = Y1 - Y2;
        dists[5].dX = X1 - X2;
        dists[5].dY = Y1 - Y2_;
        dists[6].dX = X1 - X2_;
        dists[6].dY = Y1 - Y2_;
        dists[7].dX = X1 - X2_;
        dists[7].dY = Y1_ - Y2;
        dists[8].dX = X1_ - X2;
        dists[8].dY = Y1 - Y2_;
        i = 0;
        while (i < dists.length) {
            dists[i].distSquare = dists[i].dX * dists[i].dX + dists[i].dY * dists[i].dY;
            ++i;
        }
        Arrays.sort(dists, new DistValuesComparator());
        return dists;
    }

    public class DistValues {
        public int distSquare = 0;
        public int dX = 0;
        public int dY = 0;
    }

    public class DistValuesComparator
    implements Comparator<DistValues> {
        @Override
        public int compare(DistValues arg0, DistValues arg1) {
            if (arg0.distSquare < arg1.distSquare) {
                return -1;
            }
            if (arg0.distSquare > arg1.distSquare) {
                return 1;
            }
            return 0;
        }
    }
}

