/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import commands.AICommand;
import commands.IAICommand;
import commands.KeyCommand;
import global.Logger;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import simulation.ICommunicationToSimulation;
import simulation.Memory;
import simulation.SimulationDisplay;

public class SimulationExecutor
extends Thread {
    private Memory memory = null;
    private Logger logger = null;
    private SimulationDisplay display = null;
    private ICommunicationToSimulation communicator = null;
    private IAICommand commandTree = null;
    private ExecutorStatus status = ExecutorStatus.UNKNOWN;
    public boolean shutdown = false;

    public SimulationExecutor() {
        this.setName("SimulationExecutor");
    }

    public void setCommandTree(IAICommand cmd) {
        this.commandTree = cmd;
    }

    public IAICommand getCommandTree() {
        return this.commandTree;
    }

    public void setDisplay(SimulationDisplay newDisplay) {
        this.display = newDisplay;
    }

    @Override
    public void run() {
        DateFormat df;
        Date d2;
        this.status = ExecutorStatus.STARTING;
        boolean started = false;
        this.shutdown = false;
        this.initialize();
        GameFinishedListener gfl = new GameFinishedListener();
        while (!this.isInterrupted() && !this.shutdown) {
            if (this.gameRunning() || started) {
                if (!started) {
                    d2 = new Date();
                    df = DateFormat.getTimeInstance(2, Locale.GERMANY);
                    System.out.println(String.valueOf(df.format(d2)) + " SimulationExecutor.run(): START START START START START START");
                    started = true;
                    this.status = ExecutorStatus.RUNNING;
                    gfl.start();
                }
                this.doStep();
                try {
                    SimulationExecutor.sleep(1L);
                }
                catch (InterruptedException d2) {
                    // empty catch block
                }
            }
            if (this.gameRunning()) continue;
            if (started) {
                if (!this.isReallyFinished()) continue;
                ((AICommand)this.commandTree).stopExec();
                break;
            }
            this.startGame();
        }
        gfl.stop = true;
        this.status = ExecutorStatus.FINISHED;
        this.communicator.resetKeys();
        d2 = new Date();
        df = DateFormat.getTimeInstance(2, Locale.GERMANY);
        System.out.println(String.valueOf(df.format(d2)) + " SimulationExecutor.run(): SimulationExeccutor.run(): stop " + this.display.getLastPoints());
        this.clear();
    }

    private boolean isReallyFinished() {
        String tmp = this.display.getDisplayText();
        if (tmp.indexOf("SPIELENDE") > -1 || tmp.indexOf("IHR ERGEBNIS IST EINES DER ZEHN BESTEN") > -1 || tmp.indexOf("STARTKNOEPFE DRUECKEN") > -1) {
            Date d = new Date();
            DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
            System.out.println(String.valueOf(df.format(d)) + " SimulationExecutor.isReallyFinished(): Game end detected");
            return true;
        }
        return false;
    }

    public void initialize() {
        this.initializeMemory();
    }

    public void initializeMemory() {
        this.memory = new Memory();
        this.memory.setSize(500);
    }

    public void doStep() {
        this.commandTree.doCommand();
        this.logger.clear();
    }

    public void clear() {
    }

    public void setLogger(Logger newLogger) {
        this.logger = newLogger;
    }

    public boolean gameRunning() {
        if (this.display != null) {
            return this.display.checkPlayerShipVisible();
        }
        return false;
    }

    public void startGame() {
        if (this.communicator != null) {
            this.communicator.resetKeys();
            int i = 0;
            while (i < 3) {
                this.skipInsertTopListMessage();
                ++i;
            }
            this.communicator.sendKey(5, KeyCommand.Type.PRESS);
            this.communicator.sendKey(5, KeyCommand.Type.RELEASE);
            try {
                SimulationExecutor.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            System.out.println("SimulationExecutor.startGame(): ERROR: communicator missing (SimulationExecutor)");
        }
    }

    private void skipInsertTopListMessage() {
        String tmp = this.display.getDisplayText();
        if (tmp.indexOf("IHR ERGEBNIS IST EINES DER ZEHN BESTEN") > -1) {
            this.communicator.sendKey(4, KeyCommand.Type.PRESS);
            this.communicator.sendKey(4, KeyCommand.Type.RELEASE);
        }
        try {
            SimulationExecutor.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setCommunicator(ICommunicationToSimulation communicator) {
        this.communicator = communicator;
    }

    public ExecutorStatus getStatus() {
        return this.status;
    }

    public static enum ExecutorStatus {
        UNKNOWN,
        STARTING,
        RUNNING,
        FINISHED;

    }

    private class GameFinishedListener
    extends Thread {
        public boolean stop = false;

        public GameFinishedListener() {
            this.setName("GameFinishedListener");
        }

        @Override
        public void run() {
            while (!this.stop) {
                if (SimulationExecutor.this.isReallyFinished()) {
                    ((AICommand)SimulationExecutor.this.commandTree).stopExec();
                    Date d = new Date();
                    DateFormat df = DateFormat.getTimeInstance(2, Locale.GERMANY);
                    System.out.println(String.valueOf(df.format(d)) + " GameFinishedListener.run(): Game end detected");
                    break;
                }
                try {
                    GameFinishedListener.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

