/*
 * Decompiled with CFR 0.152.
 */
package simulationTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import simulation.SimulationDisplay;

public class DisplayTest
extends TestCase {
    private final int defaultSizeOfDisplay = 500;
    private SimulationDisplay display = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.display = new SimulationDisplay();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInitialise() {
        this.display.initialise();
        int i = 0;
        while (i < this.display.getSize()) {
            DisplayTest.assertEquals(0, this.display.getValue(i));
            ++i;
        }
    }

    public void testSetSize() {
        DisplayTest.assertEquals(500, this.display.setSize(300));
    }

    public void testGetSize() {
        DisplayTest.assertEquals(500, this.display.getSize());
    }

    public void testGetValue() {
    }

    public void testSetValue() {
        DisplayTest.assertEquals(0, this.display.setValue(5, 100));
    }

    public void testSetCommunication() {
    }

    public void testCalcMinDistance() {
        DisplayTest.assertEquals(0, this.display.calcMinDistance(512, 128, 512, 895, true));
        DisplayTest.assertEquals(1, this.display.calcMinDistance(512, 128, 512, 895, false));
        DisplayTest.assertEquals(0, this.display.calcMinDistance(512, 895, 512, 128, true));
        DisplayTest.assertEquals(-1, this.display.calcMinDistance(512, 895, 512, 128, false));
        DisplayTest.assertEquals(-1, this.display.calcMinDistance(1023, 390, 0, 390, true));
        DisplayTest.assertEquals(0, this.display.calcMinDistance(1023, 390, 0, 390, false));
        DisplayTest.assertEquals(1, this.display.calcMinDistance(0, 390, 1023, 390, true));
        DisplayTest.assertEquals(0, this.display.calcMinDistance(0, 390, 1023, 390, false));
        DisplayTest.assertEquals(-1, this.display.calcMinDistance(1023, 128, 0, 895, true));
        DisplayTest.assertEquals(1, this.display.calcMinDistance(1023, 128, 0, 895, false));
        DisplayTest.assertEquals(1, this.display.calcMinDistance(0, 895, 1023, 128, true));
        DisplayTest.assertEquals(-1, this.display.calcMinDistance(0, 895, 1023, 128, false));
        DisplayTest.assertEquals(1, this.display.calcMinDistance(0, 128, 1023, 895, true));
        DisplayTest.assertEquals(1, this.display.calcMinDistance(0, 128, 1023, 895, false));
        DisplayTest.assertEquals(-1, this.display.calcMinDistance(1023, 895, 0, 128, true));
        DisplayTest.assertEquals(-1, this.display.calcMinDistance(1023, 895, 0, 128, false));
        DisplayTest.assertEquals(-30, this.display.calcMinDistance(500, 400, 530, 380, true));
        DisplayTest.assertEquals(20, this.display.calcMinDistance(500, 400, 530, 380, false));
        DisplayTest.assertEquals(30, this.display.calcMinDistance(530, 380, 500, 400, true));
        DisplayTest.assertEquals(-20, this.display.calcMinDistance(530, 380, 500, 400, false));
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Display");
        suite.addTestSuite(DisplayTest.class);
        return suite;
    }
}

