package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.ACosCommand;
import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;

public class ACosCommandTest extends TestCase {

	private ACosCommand acosCommand = null;
	private AICommand aiCommand = null;
	
	public ACosCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		acosCommand = new ACosCommand();
		aiCommand = acosCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("ACOS", acosCommand.getShortName());
		assertEquals("ACOS", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Arcuscosinus", acosCommand.getLongName());
		assertEquals("Arcuscosinus", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, acosCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,acosCommand.getCurrentParameterCount());
		acosCommand.addParameter(mock1);
		acosCommand.addParameter(mock2);
		assertEquals(1,acosCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		acosCommand.addParameter(nc1);
		assertEquals(1097,acosCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(1,acosCommand.getCurrentParameterCount());
		assertEquals(1570,acosCommand.doCommand());
		nc1.setNumber(-1570);
		assertEquals(2177,acosCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(acosCommand.isThisCommand("ACOS") != null);
		assertTrue(acosCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		acosCommand.addParameter(nc1);
		assertEquals("ACOS 123456",acosCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("ACosCommand");
		suite.addTestSuite(ACosCommandTest.class);
		return suite;
	}
}
