package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.ASinCommand;
import commands.IAICommand;
import commands.NumberCommand;

public class ASinCommandTest extends TestCase {

	private ASinCommand asinCommand = null;
	private AICommand aiCommand = null;
	
	public ASinCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		asinCommand = new ASinCommand();
		aiCommand = asinCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("ASIN", asinCommand.getShortName());
		assertEquals("ASIN", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Arcussinus", asinCommand.getLongName());
		assertEquals("Arcussinus", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, asinCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,asinCommand.getCurrentParameterCount());
		asinCommand.addParameter(mock1);
		asinCommand.addParameter(mock2);
		assertEquals(1,asinCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		asinCommand.addParameter(nc1);
		assertEquals(473,asinCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(1,asinCommand.getCurrentParameterCount());
		assertEquals(0,asinCommand.doCommand());
		nc1.setNumber(-1570);
		assertEquals(-606,asinCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(asinCommand.isThisCommand("ASIN") != null);
		assertTrue(asinCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		asinCommand.addParameter(nc1);
		assertEquals("ASIN 123456",asinCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("ASinCommand");
		suite.addTestSuite(ASinCommandTest.class);
		return suite;
	}
}
