package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.ATanCommand;
import commands.IAICommand;
import commands.NumberCommand;

public class ATanCommandTest extends TestCase {

	private ATanCommand atanCommand = null;
	private AICommand aiCommand = null;
	
	public ATanCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		atanCommand = new ATanCommand();
		aiCommand = atanCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("ATAN", atanCommand.getShortName());
		assertEquals("ATAN", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Arcustangens", atanCommand.getLongName());
		assertEquals("Arcustangens", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, atanCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,atanCommand.getCurrentParameterCount());
		atanCommand.addParameter(mock1);
		atanCommand.addParameter(mock2);
		assertEquals(1,atanCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		atanCommand.addParameter(nc1);
		assertEquals(1562,atanCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(1,atanCommand.getCurrentParameterCount());
		assertEquals(0,atanCommand.doCommand());
		nc1.setNumber(-1570);
		assertEquals(-1003,atanCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(atanCommand.isThisCommand("ATAN") != null);
		assertTrue(atanCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		atanCommand.addParameter(nc1);
		assertEquals("ATAN 123456",atanCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("ATanCommand");
		suite.addTestSuite(ATanCommandTest.class);
		return suite;
	}
}
