package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.AddCommand;
import commands.IAICommand;
import commands.NumberCommand;

public class AddCommandTest extends TestCase {

	private AddCommand addCommand = null;
	private AICommand aiCommand = null;
	
	public AddCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		addCommand = new AddCommand();
		aiCommand = addCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("ADD", addCommand.getShortName());
		assertEquals("ADD", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("+", addCommand.getLongName());
		assertEquals("+", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, addCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,addCommand.getCurrentParameterCount());
		addCommand.addParameter(mock1);
		addCommand.addParameter(mock2);
		assertEquals(2,addCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		addCommand.addParameter(nc1);
		try {
			assertEquals(123456,addCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		addCommand.addParameter(nc2);
		assertEquals(2,addCommand.getCurrentParameterCount());
		assertEquals(777777,addCommand.doCommand());
		//IAICommand mock1 = createStrictMock(IAICommand.class);
		//expect(mock1.doCommand()).andReturn(123456);
		//expect(mock1.doCommand()).andReturn(123456);
		//expect(mock1.doCommand()).andReturn(654321);
		//replay();
		//addCommand.addParameter(mock1);
		//addCommand.addParameter(mock1);
		//assertEquals(2,addCommand.getCurrentParameterCount());
		//assertEquals(777777,addCommand.doCommand());
		//verify(mock1);
	}
	
	public void testIsThisCommand() {
		assertTrue(addCommand.isThisCommand("ADD") != null);
		assertTrue(addCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		addCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		addCommand.addParameter(nc2);
		assertEquals("ADD 123456 654321",addCommand.getString());
	}
	
	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("AddCommand");
		suite.addTestSuite(AddCommandTest.class);
		return suite;
	}
}
