package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.AndCommand;
import commands.IAICommand;
import commands.NumberCommand;

public class AndCommandTest extends TestCase {

	private AndCommand andCommand = null;
	private AICommand aiCommand = null;
	
	public AndCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		andCommand = new AndCommand();
		aiCommand = andCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("AND", andCommand.getShortName());
		assertEquals("AND", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("AND", andCommand.getLongName());
		assertEquals("AND", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, andCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,andCommand.getCurrentParameterCount());
		andCommand.addParameter(mock1);
		andCommand.addParameter(mock2);
		assertEquals(2,andCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		andCommand.addParameter(nc1);
		try {
			assertEquals(123456,andCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		andCommand.addParameter(nc2);
		assertEquals(2,andCommand.getCurrentParameterCount());
		assertEquals(654321,andCommand.doCommand());
		nc1.setNumber(-951753);
		assertEquals(-951753,andCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(0,andCommand.doCommand());
		nc1.setNumber(-147258);
		assertEquals(-147258,andCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(andCommand.isThisCommand("AND") != null);
		assertTrue(andCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		andCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		andCommand.addParameter(nc2);
		assertEquals("AND 123456 654321",andCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("AndCommand");
		suite.addTestSuite(AndCommandTest.class);
		return suite;
	}
}
