package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.CosCommand;
import commands.IAICommand;
import commands.NumberCommand;

public class CosCommandTest extends TestCase {

	private CosCommand cosCommand = null;
	private AICommand aiCommand = null;
	
	public CosCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		cosCommand = new CosCommand();
		aiCommand = cosCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("COS", cosCommand.getShortName());
		assertEquals("COS", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Cosinus", cosCommand.getLongName());
		assertEquals("Cosinus", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, cosCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,cosCommand.getCurrentParameterCount());
		cosCommand.addParameter(mock1);
		cosCommand.addParameter(mock2);
		assertEquals(1,cosCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		cosCommand.addParameter(nc1);
		assertEquals(-594,cosCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(1,cosCommand.getCurrentParameterCount());
		assertEquals(1000,cosCommand.doCommand());
		nc1.setNumber(1570);
		assertEquals(0,cosCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(cosCommand.isThisCommand("COS") != null);
		assertTrue(cosCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		cosCommand.addParameter(nc1);
		assertEquals("COS 123456",cosCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("CosCommand");
		suite.addTestSuite(CosCommandTest.class);
		return suite;
	}
}
