package commandTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.DisplayCommand;
import commands.NumberCommand;

public class DisplayCommandTest extends TestCase {

	private DisplayCommand displayCommand = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		displayCommand = new DisplayCommand();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("DISP", displayCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("ReadDisplay", displayCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, displayCommand.getParameterCount());
	}

	public void testDoCommand() {
		// INFO Test not finished
		NumberCommand nc = new NumberCommand();
		nc.setNumber(3000);
		displayCommand.addParameter(nc);
		assertEquals(0, displayCommand.doCommand());
	}

	public void testIsThisCommand() {
		assertTrue(displayCommand.isThisCommand("DISP") != null);
		assertTrue(displayCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		displayCommand.addParameter(nc1);
		assertEquals("DISP 123456",displayCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("DisplayCommand");
		suite.addTestSuite(DisplayCommandTest.class);
		return suite;
	}
}
