package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.DivCommand;
import commands.IAICommand;
import commands.NumberCommand;

public class DivCommandTest extends TestCase {

	private DivCommand divCommand = null;
	private AICommand aiCommand = null;
	
	public DivCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		divCommand = new DivCommand();
		aiCommand = divCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("DIV", divCommand.getShortName());
		assertEquals("DIV", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("/", divCommand.getLongName());
		assertEquals("/", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, divCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,divCommand.getCurrentParameterCount());
		divCommand.addParameter(mock1);
		divCommand.addParameter(mock2);
		assertEquals(2,divCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		divCommand.addParameter(nc1);
		try {
			assertEquals(123456,divCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		divCommand.addParameter(nc2);
		assertEquals(2,divCommand.getCurrentParameterCount());
		assertEquals(188,divCommand.doCommand());
		nc2.setNumber(0);
		assertEquals(0,divCommand.doCommand());
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		divCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		divCommand.addParameter(nc2);
		assertEquals("DIV 123456 654321",divCommand.getString());
	}

	public void testIsThisCommand() {
		assertTrue(divCommand.isThisCommand("DIV") != null);
		assertTrue(divCommand.isThisCommand("FALSCH") == null);
	}
	
	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("DivCommand");
		suite.addTestSuite(DivCommandTest.class);
		return suite;
	}
}
