package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.EquCommand;
import commands.IAICommand;
import commands.NumberCommand;

public class EquCommandTest extends TestCase {

	private EquCommand equCommand = null;
	private AICommand aiCommand = null;
	
	public EquCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		equCommand = new EquCommand();
		aiCommand = equCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("EQU", equCommand.getShortName());
		assertEquals("EQU", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Equal", equCommand.getLongName());
		assertEquals("Equal", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, equCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,equCommand.getCurrentParameterCount());
		equCommand.addParameter(mock1);
		equCommand.addParameter(mock2);
		assertEquals(2,equCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		equCommand.addParameter(nc1);
		try {
			assertEquals(-1000,equCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		equCommand.addParameter(nc2);
		assertEquals(2,equCommand.getCurrentParameterCount());
		assertEquals(-1000,equCommand.doCommand());
		nc2.setNumber(123456);
		assertEquals(+1000,equCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(equCommand.isThisCommand("EQU") != null);
		assertTrue(equCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		equCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		equCommand.addParameter(nc2);
		assertEquals("EQU 123456 654321",equCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("EquCommand");
		suite.addTestSuite(EquCommandTest.class);
		return suite;
	}
}
