package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.ITECommand;
import commands.NumberCommand;

public class ITECommandTest extends TestCase {

	private ITECommand iteCommand = null;
	private AICommand aiCommand = null;
	
	public ITECommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		iteCommand = new ITECommand();
		aiCommand = iteCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("ITE", iteCommand.getShortName());
		assertEquals("ITE", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("IfThenElse", iteCommand.getLongName());
		assertEquals("IfThenElse", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(3, iteCommand.getParameterCount());
		assertEquals(3, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,iteCommand.getCurrentParameterCount());
		iteCommand.addParameter(mock1);
		iteCommand.addParameter(mock2);
		assertEquals(2,iteCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		iteCommand.addParameter(nc1);
		try {
			assertEquals(0,iteCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(-654321);
		iteCommand.addParameter(nc2);
		NumberCommand nc3 = new NumberCommand();
		nc3.setNumber(852351);
		iteCommand.addParameter(nc3);
		assertEquals(3,iteCommand.getCurrentParameterCount());
		assertEquals(-654321,iteCommand.doCommand());
		nc1.setNumber(-951753);
		assertEquals(852351,iteCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(iteCommand.isThisCommand("ITE") != null);
		assertTrue(iteCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		iteCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		iteCommand.addParameter(nc2);
		NumberCommand nc3 = new NumberCommand();
		nc3.setNumber(15975378);
		iteCommand.addParameter(nc3);
		assertEquals("ITE 123456 654321 15975378",iteCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("ITECommand");
		suite.addTestSuite(ITECommandTest.class);
		return suite;
	}
}
