package commandTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.Key2Command;
import commands.NumberCommand;

public class Key2CommandTest extends TestCase {

	private Key2Command key2Command = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		key2Command = new Key2Command();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("KEY", key2Command.getShortName());
	}

	public void testGetLongName() {
		assertEquals("SendKey", key2Command.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, key2Command.getParameterCount());
	}

	public void testIsThisCommand() {
		Key2Command tmp = (Key2Command) key2Command.isThisCommand("KEYP");
		assertTrue(tmp == null);
		tmp = (Key2Command) key2Command.isThisCommand("KEYR");
		assertTrue(tmp == null);
		
		tmp = (Key2Command) key2Command.isThisCommand("KEY");
		assertTrue(tmp != null);
		assertEquals("KEY",tmp.getShortName());

		assertTrue(key2Command.isThisCommand("FALSCH") == null);
	}

	public void testDoCommand() {
		NumberCommand nc = new NumberCommand();
		nc.setNumber(3456);
		key2Command.addParameter(nc);
		assertEquals(3456, key2Command.doCommand());
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		key2Command.addParameter(nc1);
		assertEquals("KEY 123456",key2Command.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("Key2Command");
		suite.addTestSuite(Key2CommandTest.class);
		return suite;
	}
}
