package commandTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.KeyCommand;
import commands.NumberCommand;
import commands.KeyCommand.Type;

public class KeyCommandTest extends TestCase {

	private KeyCommand keyCommand = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		keyCommand = new KeyCommand();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		keyCommand.setType(Type.PRESS);
		assertEquals("KEYP", keyCommand.getShortName());
		keyCommand.setType(Type.RELEASE);
		assertEquals("KEYR", keyCommand.getShortName());
	}

	public void testGetLongName() {
		keyCommand.setType(Type.PRESS);
		assertEquals("SendKeyPress", keyCommand.getLongName());
		keyCommand.setType(Type.RELEASE);
		assertEquals("SendKeyRelease", keyCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, keyCommand.getParameterCount());
	}

	public void testIsThisCommand() {
		KeyCommand tmp = (KeyCommand) keyCommand.isThisCommand("KEYP");
		assertTrue(tmp != null);
		assertEquals("KEYP",tmp.getShortName());
		tmp = (KeyCommand) keyCommand.isThisCommand("KEYR");
		assertTrue(tmp != null);
		assertEquals("KEYR",tmp.getShortName());
		assertTrue(keyCommand.isThisCommand("FALSCH") == null);
	}

	public void testDoCommand() {
		NumberCommand nc = new NumberCommand();
		nc.setNumber(3456);
		keyCommand.addParameter(nc);
		assertEquals(3456, keyCommand.doCommand());
	}

	public void testGetString() {
		keyCommand.setType(Type.PRESS);
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		keyCommand.addParameter(nc1);
		assertEquals("KEYP 123456",keyCommand.getString());

		keyCommand.setType(Type.RELEASE);
		assertEquals("KEYR 123456",keyCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("KeyCommand");
		suite.addTestSuite(KeyCommandTest.class);
		return suite;
	}
}
