package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.LetCommand;
import commands.NumberCommand;

public class LetCommandTest extends TestCase {

	private LetCommand letCommand = null;
	private AICommand aiCommand = null;
	
	public LetCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		letCommand = new LetCommand();
		aiCommand = letCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("LET", letCommand.getShortName());
		assertEquals("LET", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("LessThan", letCommand.getLongName());
		assertEquals("LessThan", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, letCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,letCommand.getCurrentParameterCount());
		letCommand.addParameter(mock1);
		letCommand.addParameter(mock2);
		assertEquals(2,letCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		letCommand.addParameter(nc1);
		try {
			assertEquals(-1000,letCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		letCommand.addParameter(nc2);
		assertEquals(2,letCommand.getCurrentParameterCount());
		assertEquals(1000,letCommand.doCommand());
		nc1.setNumber(654321);
		assertEquals(-1000,letCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(letCommand.isThisCommand("LET") != null);
		assertTrue(letCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		letCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		letCommand.addParameter(nc2);
		assertEquals("LET 123456 654321",letCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("LetCommand");
		suite.addTestSuite(LetCommandTest.class);
		return suite;
	}
}
