package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.LogCommand;
import commands.NumberCommand;

public class LogCommandTest extends TestCase {

	private LogCommand logCommand = null;
	private AICommand aiCommand = null;
	
	public LogCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		logCommand = new LogCommand();
		aiCommand = logCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("LOG", logCommand.getShortName());
		assertEquals("LOG", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Logarithm", logCommand.getLongName());
		assertEquals("Logarithm", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, logCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,logCommand.getCurrentParameterCount());
		logCommand.addParameter(mock1);
		assertEquals(1,logCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		logCommand.addParameter(nc1);
		assertEquals(1,logCommand.getCurrentParameterCount());
		assertEquals(4815,logCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(0,logCommand.doCommand());
		nc1.setNumber(-654321);
		assertEquals(0,logCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(logCommand.isThisCommand("LOG") != null);
		assertTrue(logCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		logCommand.addParameter(nc1);
		assertEquals("LOG 123456",logCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("LogCommand");
		suite.addTestSuite(LogCommandTest.class);
		return suite;
	}
}
