package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.MulCommand;
import commands.NumberCommand;

public class MulCommandTest extends TestCase {

	private MulCommand mulCommand = null;
	private AICommand aiCommand = null;
	
	public MulCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		mulCommand = new MulCommand();
		aiCommand = mulCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("MUL", mulCommand.getShortName());
		assertEquals("MUL", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("*", mulCommand.getLongName());
		assertEquals("*", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, mulCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,mulCommand.getCurrentParameterCount());
		mulCommand.addParameter(mock1);
		mulCommand.addParameter(mock2);
		assertEquals(2,mulCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		mulCommand.addParameter(nc1);
		try {
			assertEquals(123456,mulCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(2000);
		mulCommand.addParameter(nc2);
		assertEquals(2,mulCommand.getCurrentParameterCount());
		assertEquals(246912,mulCommand.doCommand());
		nc2.setNumber(654321);
		assertEquals(80779853,mulCommand.doCommand());
		//IAICommand mock1 = createStrictMock(IAICommand.class);
		//expect(mock1.doCommand()).andReturn(123456);
		//expect(mock1.doCommand()).andReturn(123456);
		//expect(mock1.doCommand()).andReturn(654321);
		//replay();
		//addCommand.addParameter(mock1);
		//addCommand.addParameter(mock1);
		//assertEquals(2,addCommand.getCurrentParameterCount());
		//assertEquals(777777,addCommand.doCommand());
		//verify(mock1);
	}
	
	public void testIsThisCommand() {
		assertTrue(mulCommand.isThisCommand("MUL") != null);
		assertTrue(mulCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		mulCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		mulCommand.addParameter(nc2);
		assertEquals("MUL 123456 654321",mulCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("MulCommand");
		suite.addTestSuite(MulCommandTest.class);
		return suite;
	}
}
