package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.NotCommand;
import commands.NumberCommand;

public class NotCommandTest extends TestCase {

	private NotCommand notCommand = null;
	private AICommand aiCommand = null;
	
	public NotCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		notCommand = new NotCommand();
		aiCommand = notCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("NOT", notCommand.getShortName());
		assertEquals("NOT", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Not", notCommand.getLongName());
		assertEquals("Not", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, notCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,notCommand.getCurrentParameterCount());
		notCommand.addParameter(mock1);
		assertEquals(1,notCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		notCommand.addParameter(nc1);
		assertEquals(1,notCommand.getCurrentParameterCount());
		assertEquals(-123457,notCommand.doCommand());
		nc1.setNumber(-654321);
		assertEquals(654322,notCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(notCommand.isThisCommand("NOT") != null);
		assertTrue(notCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		notCommand.addParameter(nc1);
		assertEquals("NOT 123456",notCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("NotCommand");
		suite.addTestSuite(NotCommandTest.class);
		return suite;
	}
}
