package commandTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.NumberCommand;

public class NumberCommandTest extends TestCase {

	private NumberCommand numberCommand = null;
	private AICommand aiCommand = null;

	protected void setUp() throws Exception {
		super.setUp();
		numberCommand = new NumberCommand();
		aiCommand = numberCommand;
		numberCommand.setNumber(123456);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("123456", numberCommand.getShortName());
		assertEquals("123456", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("123.456", numberCommand.getLongName());
		assertEquals("123.456", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(0, numberCommand.getParameterCount());
		assertEquals(0, aiCommand.getParameterCount());
	}

	public void testDoCommand() {
		assertEquals(123456, numberCommand.doCommand());
		assertEquals(123456, aiCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		NumberCommand nc2 = (NumberCommand) numberCommand.isThisCommand("123456");
		assertTrue(nc2 != null);
		assertEquals("123456",nc2.getShortName());
		assertTrue(numberCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		numberCommand.setNumber(123456);
		assertEquals("123456",numberCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("NumberCommand");
		suite.addTestSuite(NumberCommandTest.class);
		return suite;
	}
}
