package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.OrCommand;

public class OrCommandTest extends TestCase {

	private OrCommand orCommand = null;
	private AICommand aiCommand = null;
	
	public OrCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		orCommand = new OrCommand();
		aiCommand = orCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("OR", orCommand.getShortName());
		assertEquals("OR", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("OR", orCommand.getLongName());
		assertEquals("OR", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, orCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,orCommand.getCurrentParameterCount());
		orCommand.addParameter(mock1);
		orCommand.addParameter(mock2);
		assertEquals(2,orCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		orCommand.addParameter(nc1);
		try {
			assertEquals(123456,orCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		orCommand.addParameter(nc2);
		assertEquals(2,orCommand.getCurrentParameterCount());
		assertEquals(123456,orCommand.doCommand());
		nc2.setNumber(-951753);
		assertEquals(123456,orCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(-951753,orCommand.doCommand());
		nc1.setNumber(-147258);
		assertEquals(-951753,orCommand.doCommand());
		nc2.setNumber(654321);
		assertEquals(654321,orCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(orCommand.isThisCommand("OR") != null);
		assertTrue(orCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		orCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		orCommand.addParameter(nc2);
		assertEquals("OR 123456 654321",orCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("OrCommand");
		suite.addTestSuite(OrCommandTest.class);
		return suite;
	}
}
